# 機能設計書 92-参照元サイト一覧

## 概要

本ドキュメントは、QuickerSite CMSの管理画面における参照元サイト一覧機能の設計を記述する。外部サイトからの流入元（リファラー）を分析し、マーケティング施策やSEO効果を測定するための機能である。

### 本機能の処理概要

参照元サイト一覧機能は、サイト管理者が外部からの流入経路を把握するための機能である。

**業務上の目的・背景**：Webマーケティングにおいて、どの外部サイトからユーザーが流入しているかを把握することは、広告効果測定やSEO施策の評価に不可欠である。本機能により、管理者は流入元サイト、検索クエリ、ランディングページなどを多角的に分析できる。これにより、効果的なプロモーション戦略の立案や、コンテンツ改善の方向性を決定できる。

**機能の利用シーン**：マーケティング担当者が広告キャンペーンの効果測定を行う際、SEO担当者が検索流入の分析を行う際、サイト運営者が外部リンクの効果を確認する際に利用される。

**主要な処理内容**：
1. 指定期間内のリファラーデータをデータベースから取得
2. グループ化条件（参照元URL、サイト、ランディングページ、IPアドレス、言語、検索クエリ）に基づいて集計
3. 集計結果をソート可能なテーブル形式で表示
4. 詳細ログ形式での全データ表示オプション提供
5. リファラーデータのリセット機能

**関連システム・外部連携**：外部システムとの直接的な連携はないが、検索エンジンからの流入を検索クエリ別に分析可能。

**権限による制御**：セカンドアドミンの`bStats`権限を持つユーザーのみアクセス可能。また、サイト設定で`bScanreferer`が有効な場合のみ利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 96 | リファラー一覧 | 主画面 | 参照元サイトの一覧表示 |
| 95 | 統計画面 | 遷移元画面 | アクセス統計からの遷移リンク |
| 143 | リファラー一覧 | 管理者用画面 | 管理者向け参照元サイト一覧 |

## 機能種別

データ参照・集計分析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| groupBy | Integer | No | グループ化条件（参照元URL、サイト、LP、IP、言語、検索クエリ、ログファイル） | 固定値リスト |
| dFrom | Date | No | 検索開始日（デフォルト：7日前） | 日付形式チェック |
| dUntill | Date | No | 検索終了日（デフォルト：当日） | 日付形式チェック |
| pageAction | String | No | アクション（Reset：リファラーリセット） | 固定値チェック |

### 入力データソース

- フォーム入力（検索条件）
- tblRefererテーブル（リファラーデータ）
- セッション情報（認証状態）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 参照元URL/サイト | String | 流入元のURL（グループ化条件による） |
| ランディングページ | String | 最初にアクセスしたページ |
| 言語 | String | ブラウザの言語設定 |
| IPアドレス | String | アクセス元IPアドレス |
| 日時 | DateTime | アクセス日時 |
| 件数 | Integer | 集計結果の件数 |

### 出力先

管理画面（bs_referers.asp）のHTMLテーブルとして表示

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのbStats権限とbScanreferer設定を確認
2. 検索条件の取得
   └─ フォームから期間とグループ化条件を取得（デフォルト値設定）
3. リセットアクション処理
   └─ pageAction=ResetならCSRFチェック後にリファラーデータを削除
4. リファラーデータ取得
   └─ getReferersArr関数で指定期間のデータを配列で取得
5. グループ化・集計処理
   └─ グループ化条件に基づいてDictionary形式で集計
6. 結果表示
   └─ グループ化集計結果またはログ形式でテーブル表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bStats権限チェック}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D{bScanreferer有効?}
    D -->|No| E[bs_stats.aspへリダイレクト]
    D -->|Yes| F[検索条件取得]
    F --> G{pageAction=Reset?}
    G -->|Yes| H[CSRFチェック]
    H --> I[リファラーデータ削除]
    I --> J[リファラーデータ取得]
    G -->|No| J
    J --> K{データあり?}
    K -->|No| L[「データなし」表示]
    K -->|Yes| M{groupBy=ログファイル?}
    M -->|Yes| N[詳細ログ表示]
    M -->|No| O[グループ集計表示]
    N --> P[終了]
    O --> P
    L --> P
    C --> P
    E --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-92-1 | 機能有効チェック | bScanreferer設定が有効でない場合は統計画面へリダイレクト | 常時 |
| BR-92-2 | デフォルト期間 | 検索期間の初期値は過去7日間 | フォーム未送信時 |
| BR-92-3 | URLデコード | 検索クエリはURLデコードして表示 | groupBy=検索クエリの場合 |
| BR-92-4 | 言語表示制限 | 言語コードは先頭5文字のみ表示 | groupBy=言語の場合 |
| BR-92-5 | リセット確認 | リファラーリセット時は確認ダイアログを表示 | Reset実行時 |

### 計算ロジック

- グループ化集計：同一キーの出現回数をDictionaryで管理
- URL正規化：filterURL関数でドメイン部分を抽出
- 検索クエリ抽出：filterQuery関数でURLからクエリ文字列を抽出

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| データ取得 | tblReferer | SELECT | 指定期間のリファラーデータ取得 |
| データ削除 | tblReferer | DELETE | リセット時のデータ削除 |

### テーブル別操作詳細

#### tblReferer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sReferer, sURL, sLandingPage, sUserIP, sLanguage, dWhen | iCustomerID = cId AND dWhen BETWEEN dFrom AND dUntill | getReferersArr関数経由 |
| DELETE | 全カラム | iCustomerID = cId | removeReferers関数経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アクセス拒否 | bStats権限なし | ログインページへリダイレクト |
| - | 機能無効 | bScanreferer=false | bs_stats.aspへリダイレクト |
| - | CSRF検証失敗 | トークン不一致 | エラーメッセージ表示 |

### リトライ仕様

特になし

## トランザクション仕様

- リセット処理時はDELETE文を単一トランザクションとして実行
- 検索処理は読み取り専用のためトランザクション管理不要

## パフォーマンス要件

- 期間指定により検索対象を限定し、パフォーマンスを確保
- sortableテーブルによりクライアントサイドでのソートが可能

## セキュリティ考慮事項

- セカンドアドミン権限（bStats）による認証・認可
- CSRFトークン検証（リセット処理時）
- URLデコード時のエラーハンドリング（On Error Resume Next）
- 出力時のサニタイズ処理（quotRep関数）
- IPアドレスの表示はセキュリティ上のリスクがあるため、権限のあるユーザーのみに限定

## 備考

- URLDecode2関数は独自実装で、標準のURLデコードが失敗した場合のフォールバック処理を含む
- 検索クエリの抽出は主要な検索エンジンのURL形式に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

リファラーデータは配列形式で取得され、グループ化条件によって処理される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_referers.asp | `asp/bs_referers.asp` | arrRef配列の構造（インデックス0-5） |

**読解のコツ**: 配列インデックスの意味は以下の通り：
- 0: 参照元URL
- 1: サイトURL
- 2: ランディングページ
- 3: ユーザーIP
- 4: 言語
- 5: 日時

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_referers.asp | `asp/bs_referers.asp` | リファラー一覧のメインファイル |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（`logon.hasaccess secondAdmin.bStats`）
2. **4-23行目**: URLDecode2関数の定義
3. **24行目**: bScanreferer設定チェック
4. **26-31行目**: フォームパラメータ取得とデフォルト値設定
5. **33-36行目**: リセットアクション処理
6. **38行目**: getReferersArr関数でデータ取得
7. **42-80行目**: グループ化条件によるswitch処理

#### Step 3: グループ化ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_referers.asp | `asp/bs_referers.asp` | 42-80行目のselect case文 |

**グループ化条件の分岐**:
- **sb_ref_REFERER**: 参照元URL別集計
- **sb_ref_URL**: 参照元サイト別集計
- **sb_ref_LP**: ランディングページ別集計
- **sb_ref_USERIP**: IPアドレス別集計
- **sb_ref_LA**: 言語別集計
- **sb_ref_QUERY**: 検索クエリ別集計
- **sb_ref_LOGFILE**: 詳細ログ表示

### プログラム呼び出し階層図

```
bs_referers.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bStats)
    │
    ├─ customer.bScanreferer チェック
    │
    ├─ cls_refGroupByList
    │      └─ showSelected()
    │
    ├─ getReferersArr(dFrom, dUntill, total)
    │      └─ tblReferer SELECT
    │
    ├─ removeReferers()（Reset時のみ）
    │      └─ tblReferer DELETE
    │
    └─ URLDecode2() / filterURL() / filterQuery()
           └─ URL文字列処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ─────▶ パラメータ検証 ───────▶ 検索条件
(dFrom, dUntill,      │
 groupBy)             ▼
                  getReferersArr()
                      │
tblReferer ─────────▶ 配列データ取得 ──────▶ arrRef配列
                      │
                      ▼
                  グループ化処理
                      │
                      ▼
               Dictionary集計 ────────▶ HTMLテーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_referers.asp | `asp/bs_referers.asp` | ソース | リファラー一覧メインページ |
| bs_stats.asp | `asp/bs_stats.asp` | ソース | 統計画面（遷移元） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | 管理画面ヘッダー |
