# 機能設計書 93-統計リセット

## 概要

本ドキュメントは、QuickerSite CMSの管理画面における統計リセット機能の設計を記述する。アクセス統計データを初期化し、新たな計測期間を開始するための機能である。

### 本機能の処理概要

統計リセット機能は、サイト管理者がアクセス統計の計測基準日をリセットするための機能である。

**業務上の目的・背景**：Webサイトの運用において、特定のイベント（サイトリニューアル、キャンペーン開始等）を基準として新たなアクセス分析を開始したい場合がある。本機能により、過去の統計データをクリアし、新たな計測期間を設定できる。これにより、期間別の比較分析やキャンペーン効果測定が正確に行える。

**機能の利用シーン**：サイトリニューアル後の効果測定開始時、新規キャンペーン開始時、年度切り替え時のアクセス統計リセット時に利用される。

**主要な処理内容**：
1. 統計リセット要求の受付とCSRFトークン検証
2. 確認ダイアログによるユーザー意図の確認
3. 統計リセット日時（dResetStats）の更新
4. 各ページのヒット数・訪問者数のリセット
5. リセット完了後の統計画面への遷移

**関連システム・外部連携**：外部システムとの連携なし。

**権限による制御**：セカンドアドミンの`bStats`権限を持つユーザーのみ実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 95 | 統計画面 | 主画面 | 統計リセットボタンの表示・実行 |

## 機能種別

データ更新・初期化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| btnaction | String | Yes | アクション種別（"ResetStats"固定） | 固定値チェック |
| セキュリティトークン | String | Yes | CSRFトークン | トークン検証 |

### 入力データソース

- クエリストリング（btnaction, セキュリティトークン）
- セッション情報（認証状態）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| リダイレクト | - | bs_stats.aspへのリダイレクト |

### 出力先

- tblCustomer.dResetStats（リセット日時更新）
- tblPage.iHits, iVisitors（統計カウンタリセット）

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのbStats権限を確認
2. アクション判定
   └─ btnaction=ResetStatsの場合に処理続行
3. CSRFトークン検証
   └─ セキュリティコードの検証
4. 確認ダイアログ表示
   └─ JavaScript confirm()による最終確認
5. 統計データリセット
   └─ dResetStatsを現在日時に更新
   └─ 各ページのiHits, iVisitorsを0にリセット
6. リダイレクト
   └─ bs_stats.aspに戻る
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bStats権限チェック}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D{btnaction=ResetStats?}
    D -->|No| E[統計表示処理]
    D -->|Yes| F[CSRFトークン検証]
    F --> G{トークン有効?}
    G -->|No| H[エラー表示]
    G -->|Yes| I[confirm表示]
    I --> J{ユーザー確認}
    J -->|キャンセル| E
    J -->|OK| K[dResetStats更新]
    K --> L[ページ統計リセット]
    L --> M[bs_stats.aspへリダイレクト]
    E --> N[終了]
    M --> N
    H --> N
    C --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-93-1 | 権限チェック | bStats権限を持つセカンドアドミンのみ実行可能 | 常時 |
| BR-93-2 | 確認必須 | リセット実行前に確認ダイアログを表示 | 常時 |
| BR-93-3 | CSRF対策 | セキュリティトークンの検証が必要 | 常時 |
| BR-93-4 | 日数再計算 | リセット後、日次平均計算の基準日が更新される | リセット後 |

### 計算ロジック

- リセット後の日次平均 = ヒット数 / (現在日 - dResetStats)
- リセット直後は0除算を回避するため、日数は最小1日として計算

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 日時更新 | tblCustomer | UPDATE | リセット日時の記録 |
| 統計リセット | tblPage | UPDATE | ヒット数・訪問者数の初期化 |

### テーブル別操作詳細

#### tblCustomer

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | dResetStats | Now() | iId = cId |

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | iHits | 0 | iCustomerID = cId |
| UPDATE | iHitsRSS | 0 | iCustomerID = cId |
| UPDATE | iVisitors | 0 | iCustomerID = cId |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アクセス拒否 | bStats権限なし | ログインページへリダイレクト |
| - | CSRF検証失敗 | トークン不一致 | エラーメッセージ表示 |

### リトライ仕様

リセット処理が失敗した場合、再度リセットボタンをクリックして実行可能

## トランザクション仕様

- tblCustomerとtblPageの更新は論理的に同一トランザクションとして扱うべき
- 現実装ではASPの暗黙的なトランザクション管理に依存

## パフォーマンス要件

- リセット処理は全ページに対するUPDATE文を実行するため、ページ数に比例して処理時間が増加
- 数千ページ規模のサイトでは数秒程度の処理時間を想定

## セキュリティ考慮事項

- セカンドアドミン権限（bStats）による認証・認可
- CSRFトークン検証による不正リクエスト防止
- JavaScript confirm()による誤操作防止
- 操作ログの記録（監査証跡）

## 備考

- リセット操作は取り消し不可のため、慎重な操作が必要
- リセット前のデータが必要な場合は、事前にExcel等でエクスポートすることを推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

統計リセットはbs_stats.asp内のアクション処理として実装されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_stats.asp | `asp/bs_stats.asp` | ResetStatsアクションの処理フロー |

**主要処理フロー**:
1. **17行目**: リセットリンクの生成（`btnaction=ResetStats`）
2. **17行目**: 確認ダイアログ（`confirm('<%=l("areyousure")%>')`）
3. **17行目**: CSRFトークン付きURL（`QS_secCodeURL`）

**読解のコツ**: bs_stats.aspではリンクの生成のみを行い、実際のリセット処理はbs_process.aspまたはインクルードファイルで実行される。

#### Step 2: リセット処理の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_process.asp | `asp/bs_process.asp` | btnaction=ResetStatsの処理分岐 |

**主要処理フロー**:
- **btnactionの分岐処理**: ResetStatsの場合にリセット処理を実行
- **customer.resetStats()**: Customerクラスのリセットメソッド呼び出し

#### Step 3: Customerクラスのリセットメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | customer.asp | `asp/includes/customer.asp` | resetStatsメソッドの実装 |

**想定される処理**:
- dResetStatsフィールドの更新
- tblPageの統計カラムリセット

### プログラム呼び出し階層図

```
bs_stats.asp
    │
    ├─ リセットリンク生成
    │      └─ ?btnaction=ResetStats&セキュリティトークン
    │
    └─ クリック時
           │
           ├─ JavaScript confirm()
           │
           └─ bs_process.asp (または直接処理)
                  │
                  ├─ checkCSRF()
                  │
                  └─ customer.resetStats() または直接SQL
                         │
                         ├─ tblCustomer UPDATE (dResetStats)
                         │
                         └─ tblPage UPDATE (iHits, iVisitors)
```

### データフロー図

```
[入力]               [処理]                    [出力]

クリック ─────────▶ confirm() ──────────▶ 確認結果
                        │
                        ▼ (OK)
セキュリティトークン ─▶ checkCSRF() ────────▶ 検証結果
                        │
                        ▼ (有効)
                   resetStats()
                        │
                        ├──▶ tblCustomer UPDATE
                        │
                        └──▶ tblPage UPDATE
                                │
                                ▼
                        bs_stats.aspへリダイレクト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_stats.asp | `asp/bs_stats.asp` | ソース | 統計表示・リセットリンク |
| bs_process.asp | `asp/bs_process.asp` | ソース | アクション処理の振り分け |
| customer.asp | `asp/includes/customer.asp` | ソース | Customerクラス定義（推定） |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
