# 機能設計書 94-定数一覧

## 概要

本ドキュメントは、QuickerSite CMSの管理画面における定数一覧機能の設計を記述する。サイト全体で使用可能な定数（テンプレート変数）を一覧表示し、管理するための機能である。

### 本機能の処理概要

定数一覧機能は、テンプレートやコンテンツ内で使用できる再利用可能な定数（変数）を一覧表示する機能である。

**業務上の目的・背景**：CMSの運用において、ヘッダー情報、連絡先、会社情報など、サイト内の複数箇所で使用される共通情報を一元管理することは、保守性と一貫性の観点から重要である。本機能により、定数を定義・管理することで、変更時の修正箇所を最小限に抑え、サイト全体の整合性を保つことができる。

**機能の利用シーン**：テンプレート設計時に使用可能な定数を確認する際、新規定数を作成する際、既存定数を編集する際に利用される。

**主要な処理内容**：
1. 登録済み定数の一覧取得（tblConstantテーブル）
2. 定数種別（テキスト/HTML）によるフィルタリング表示
3. 定数名のコピー用テキストボックス表示
4. 各定数のオンライン/オフライン状態表示
5. 定数編集画面へのリンク提供
6. ASP/VBScriptスクリプト管理画面へのリンク提供

**関連システム・外部連携**：外部システムとの連携なし。定数はテンプレートエンジンで`[定数名]`形式で参照される。

**権限による制御**：セカンドアドミンの`bHomeConstants`権限を持つユーザーのみアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 87 | 定数一覧 | 主画面 | サイト全体で使用する定数の一覧表示 |
| 88 | 定数編集 | 遷移先画面 | 定数編集画面への遷移 |
| 94 | スクリプト一覧 | 遷移先画面 | ASP/VBScriptスクリプト管理画面への遷移 |

## 機能種別

データ参照・一覧表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | 一覧表示のため入力パラメータなし | - |

### 入力データソース

- セッション情報（認証状態）
- tblConstantテーブル（定数データ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sConstant | String | 定数名 |
| iType | Integer | 定数種別（テキスト/HTML/VBScript） |
| iId | Integer | 定数ID |
| statusString | String | オンライン状態（オンライン/オフライン） |

### 出力先

管理画面（bs_constantList.asp）のHTMLリストとして表示

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのbHomeConstants権限を確認
2. ヘッダー情報出力
   └─ ナビゲーションリンク（ページ一覧、新規定数、スクリプト管理）
3. 定数データ取得
   └─ customer.constantsプロパティで全定数を取得
4. 一覧表示
   └─ VBScript以外の定数を順次表示
   └─ コピー用テキストボックス、編集リンク、種別、状態を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bHomeConstants権限チェック}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D[ヘッダー・ナビゲーション出力]
    D --> E[定数一覧取得]
    E --> F{定数あり?}
    F -->|No| G[空リスト表示]
    F -->|Yes| H[ループ開始]
    H --> I{iType = VBScript?}
    I -->|Yes| J[スキップ]
    I -->|No| K[定数情報表示]
    K --> L[コピー用テキストボックス]
    L --> M[編集リンク]
    M --> N[種別・状態表示]
    J --> O{次の定数あり?}
    N --> O
    O -->|Yes| H
    O -->|No| P[終了]
    G --> P
    C --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-94-1 | 権限チェック | bHomeConstants権限を持つセカンドアドミンのみアクセス可能 | 常時 |
| BR-94-2 | VBScript除外 | 定数一覧ではVBScript種別は表示しない | iType = QS_VBScript |
| BR-94-3 | 定数参照形式 | 定数は`[定数名]`形式でテンプレート内から参照 | テンプレート内 |
| BR-94-4 | 状態表示 | オフライン定数は色付きで「(offline)」と表示 | bOnline = false |

### 計算ロジック

- オンライン判定：dOnlineFrom <= 現在日 <= dOnlineUntill

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | tblConstant | SELECT | サイトの全定数取得 |

### テーブル別操作詳細

#### tblConstant

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sConstant, iType, dOnlineFrom, dOnlineUntill | iCustomerID = cId | customer.constantsプロパティ経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アクセス拒否 | bHomeConstants権限なし | ログインページへリダイレクト |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用の処理のため、トランザクション管理は不要

## パフォーマンス要件

- 定数数が100件以下であれば即時レスポンス
- キャッシュされた定数データ（customer.constants）を使用

## セキュリティ考慮事項

- セカンドアドミン権限（bHomeConstants）による認証・認可
- 出力時のサニタイズ処理（sanitize関数）
- VBScript種別の定数は別画面（bs_scriptList.asp）で管理し、コードインジェクションリスクを軽減

## 備考

- 定数はテンプレート解析時に`treatConstants`関数で置換される
- VBScript種別の定数は動的コード実行が可能なため、高度な権限（bHomeVBScript）で別管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

定数データはcls_constantクラスで管理される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constant.asp | `asp/includes/constant.asp` | cls_constantクラスの定義 |

**読解のコツ**:
- **3行目**: 定数のプロパティ定義（iId, sConstant, sValue, iType, dOnlineFrom, dOnlineUntill）
- **87-89行目**: bOnlineプロパティの判定ロジック
- **90-96行目**: statusStringプロパティの実装

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_constantList.asp | `asp/bs_constantList.asp` | 定数一覧のメインファイル |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（`logon.hasaccess secondAdmin.bHomeConstants`）
2. **4行目**: ナビゲーションリンクの出力
3. **6行目**: 定数一覧の取得（`customer.constants`）
4. **9-11行目**: 各定数のループ処理とVBScript除外判定
5. **10行目**: 定数情報の出力（コピー用テキストボックス、編集リンク、種別、状態）

#### Step 3: 定数種別リストを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_constantList.asp | `asp/bs_constantList.asp` | cls_formatListクラスの使用 |

**主要処理フロー**:
- **8行目**: `set formatList=new cls_formatList`
- **10行目**: `formatList.showSelected("single",cconstants(keyconstants).iType)`

### プログラム呼び出し階層図

```
bs_constantList.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bHomeConstants)
    │
    ├─ customer.constants
    │      └─ tblConstant SELECT (キャッシュ済み)
    │
    ├─ cls_formatList
    │      └─ showSelected() - 種別名の表示
    │
    └─ cls_constant
           └─ statusString - 状態文字列の取得
```

### データフロー図

```
[入力]               [処理]                    [出力]

セッション情報 ───▶ bs_security.asp ───▶ 権限チェック結果
                        │
                        ▼
tblConstant ─────▶ customer.constants ──▶ 定数Dictionary
(キャッシュ)            │
                        ▼
                  VBScript除外フィルタ
                        │
                        ▼
               cls_formatList ──────────▶ HTMLリスト
                        │
                        └──▶ コピー用テキストボックス
                        └──▶ 編集リンク
                        └──▶ 種別・状態表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_constantList.asp | `asp/bs_constantList.asp` | ソース | 定数一覧メインページ |
| bs_constantEdit.asp | `asp/bs_constantEdit.asp` | ソース | 定数編集画面 |
| bs_scriptList.asp | `asp/bs_scriptList.asp` | ソース | VBScript定数一覧 |
| constant.asp | `asp/includes/constant.asp` | ソース | cls_constantクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | 管理画面ヘッダー |
