# 機能設計書 95-定数作成・編集

## 概要

本ドキュメントは、QuickerSite CMSの管理画面における定数作成・編集機能の設計を記述する。テンプレート内で使用できる変数・定数を作成・編集・削除するための機能である。

### 本機能の処理概要

定数作成・編集機能は、サイト全体で再利用可能な定数（テキスト、HTML、VBScript）を管理するための機能である。

**業務上の目的・背景**：CMSの柔軟な運用において、サイト全体で共通して使用する情報（会社名、住所、電話番号等）や、動的に生成されるコンテンツ（カスタムスクリプト）を一元管理することは重要である。本機能により、定数の種別に応じた適切な編集インターフェースを提供し、テンプレート設計の効率化と保守性向上を実現する。

**機能の利用シーン**：新規定数の作成時、既存定数の内容更新時、不要な定数の削除時、VBScriptのテスト実行時に利用される。

**主要な処理内容**：
1. 定数の新規作成（テキスト/HTML/VBScript種別選択）
2. 定数の編集（種別に応じた入力インターフェース提供）
3. 定数の削除（確認ダイアログ付き）
4. オンライン期間の設定（公開期間制御）
5. VBScriptのテスト実行機能
6. 定数の使用箇所検索（参照先一覧表示）

**関連システム・外部連携**：外部システムとの連携なし。VBScript種別の場合はサーバーサイドで動的実行される。

**権限による制御**：セカンドアドミンの`bHomeConstants`権限を持つユーザーのみアクセス可能。VBScript種別は追加で`bHomeVBScript`権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | 定数編集 | 主画面 | テンプレート内で使用する変数・定数の管理 |
| 89 | 定数テスト | 遷移先画面 | VBScriptのテスト実行 |
| 87 | 定数一覧 | 遷移元画面 | 定数一覧からの編集遷移 |

## 機能種別

CRUD操作（Create/Read/Update/Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iContentId | String(暗号化) | No | 編集対象の定数ID（新規時は空） | 復号化後に数値チェック |
| sConstant | String | Yes | 定数名（最大20文字） | 空白不可、一意性チェック |
| sValue | String | Yes | 定数値 | 空白不可（種別による） |
| iType | Integer | Yes | 定数種別（テキスト/HTML/VBScript） | 固定値リスト |
| dOnlineFrom | Date | No | オンライン開始日 | 日付形式チェック |
| dOnlineUntill | Date | No | オンライン終了日 | 日付形式チェック |
| sParameters | String | No | VBScriptパラメータ定義 | VBScript種別時のみ |
| sGlobal | String | No | グローバルコード | VBScript種別時のみ |
| btnaction | String | Yes | アクション（保存/削除） | 固定値チェック |

### 入力データソース

- フォーム入力
- セッション情報（認証状態）
- tblConstantテーブル（既存定数データ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 保存結果 | Boolean | 保存成功/失敗 |
| エラーメッセージ | String | バリデーションエラー内容 |
| 使用箇所一覧 | HTML | 定数が使用されているページ・テンプレート一覧 |

### 出力先

- tblConstantテーブル（定数データ保存）
- 管理画面（編集フォーム表示）

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのbHomeConstants権限を確認
2. 定数オブジェクト初期化
   └─ cls_constantクラスをインスタンス化
   └─ 既存IDがある場合はデータをロード
3. ポストバック処理
   └─ フォーム送信値をオブジェクトに反映
4. アクション分岐
   └─ 保存：バリデーション→保存→メッセージ表示
   └─ 削除：削除→一覧画面へリダイレクト
5. フォーム表示
   └─ 種別に応じた入力エリアを表示
6. 使用箇所検索
   └─ 既存定数の場合、参照先を検索して表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bHomeConstants権限チェック}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D[cls_constant初期化]
    D --> E{iContentIdあり?}
    E -->|Yes| F[既存データロード]
    E -->|No| G[新規状態]
    F --> H{postback?}
    G --> H
    H -->|Yes| I[フォーム値を反映]
    H -->|No| J[フォーム表示]
    I --> K{btnaction判定}
    K -->|保存| L[CSRFチェック]
    L --> M{バリデーション}
    M -->|NG| N[エラー表示]
    M -->|OK| O[save実行]
    O --> P[成功メッセージ]
    K -->|削除| Q[CSRFチェック]
    Q --> R[remove実行]
    R --> S{VBScript?}
    S -->|Yes| T[bs_scriptList.aspへ]
    S -->|No| U[bs_constantList.aspへ]
    P --> J
    N --> J
    J --> V{既存定数?}
    V -->|Yes| W[使用箇所検索]
    V -->|No| X[終了]
    W --> X
    T --> X
    U --> X
    C --> X
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-95-1 | 定数名一意性 | 同一サイト内で定数名は一意でなければならない | 保存時 |
| BR-95-2 | 定数名制限 | 角括弧`[]`は定数名に使用不可（自動除去） | 保存時 |
| BR-95-3 | 必須項目 | 定数名と値は必須 | 保存時 |
| BR-95-4 | VBScript確認 | VBScript保存時は確認ダイアログを表示 | iType=VBScript |
| BR-95-5 | キャッシュ更新 | 保存・削除後に定数キャッシュを更新 | 保存/削除後 |

### 計算ロジック

- 定数名正規化：角括弧を除去し、大文字に変換
- オンライン判定：dOnlineFrom <= 現在日 <= dOnlineUntill

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 読み込み | tblConstant | SELECT | 既存定数データの取得 |
| 新規作成 | tblConstant | INSERT | 定数の新規登録 |
| 更新 | tblConstant | UPDATE | 定数の更新 |
| 削除 | tblConstant | DELETE | 定数の削除 |
| 一意性チェック | tblConstant | SELECT COUNT | 定数名の重複確認 |

### テーブル別操作詳細

#### tblConstant

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId = 指定ID AND iCustomerID = cId | pick関数経由 |
| INSERT | sConstant, sValue, iType, iCustomerID, dOnlineFrom, dOnlineUntill, sParameters, sGlobal | フォーム入力値 | save関数経由 |
| UPDATE | sConstant, sValue, iType, dOnlineFrom, dOnlineUntill, sParameters, sGlobal | フォーム入力値 | save関数経由 |
| DELETE | - | iId = 指定ID | remove関数経由 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| err_mandatory | 必須エラー | 定数名または値が空 | エラーメッセージ表示 |
| err_constant | 重複エラー | 同名の定数が既に存在 | エラーメッセージ表示 |
| - | CSRF検証失敗 | トークン不一致 | エラーメッセージ表示 |

### リトライ仕様

バリデーションエラー時は入力値を保持してフォームを再表示

## トランザクション仕様

- 単一テーブルへの操作のため、ADOの暗黙的トランザクション管理で十分
- 保存後のキャッシュ更新（cacheConstants）は別処理

## パフォーマンス要件

- 使用箇所検索は正規表現による全文検索のため、コンテンツ量に比例して時間がかかる
- HTMLエディタ（FCK）のロードに数秒を要する場合がある

## セキュリティ考慮事項

- セカンドアドミン権限（bHomeConstants、bHomeVBScript）による認証・認可
- CSRFトークン検証
- VBScript実行前の確認ダイアログ
- VBScriptテスト実行は別ウィンドウで分離
- 出力時のサニタイズ処理（quotRep関数）
- VBScript種別は高リスクのため、専用権限で制御

## 備考

- 定数値がHTMLの場合はFCKEditorを使用
- VBScript定数はResponse.WriteまたはCustomFunction変数への代入で出力
- 使用箇所検索は正規表現パターン`\[+(定数名)+[\(]+[\S| ]+[\)]+[\]]|\[+(定数名)+[\]]`を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

定数データはcls_constantクラスで管理される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | constant.asp | `asp/includes/constant.asp` | cls_constantクラスの全メソッド |

**読解のコツ**:
- **3行目**: プロパティ定義（iId, sConstant, sValue, iType, dOnlineFrom, dOnlineUntill, sParameters, sGlobal）
- **11-28行目**: pick関数（データ読み込み）
- **29-48行目**: check関数（バリデーション）
- **49-77行目**: save関数（保存処理）
- **78-86行目**: getRequestValues関数（フォーム値取得）
- **97-104行目**: remove関数（削除処理）

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_constantEdit.asp | `asp/bs_constantEdit.asp` | 定数編集のメインファイル |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（`logon.hasaccess secondAdmin.bHomeConstants`）
2. **5-6行目**: cls_constantの初期化とpostback判定
3. **9-24行目**: アクション分岐（保存/削除）
4. **26-32行目**: 種別選択による表示切り替え
5. **33-44行目**: 使用箇所検索（cls_fullSearch）
6. **45行目**: VBScriptテスト用フォーム

#### Step 3: 使用箇所検索ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fullsearch.asp | `asp/includes/fullsearch.asp` | cls_fullSearchクラス |

**主要処理フロー**:
- **265-400行目**: search関数の実装
- **正規表現パターン**: `\[+(定数名)+[\(]+[\S| ]+[\)]+[\]]|\[+(定数名)+[\]]`

### プログラム呼び出し階層図

```
bs_constantEdit.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bHomeConstants)
    │
    ├─ cls_constant
    │      ├─ pick(id) - データ読み込み
    │      ├─ getRequestValues() - フォーム値取得
    │      ├─ check() - バリデーション
    │      ├─ save() - 保存
    │      │      └─ customer.cacheConstants()
    │      └─ remove() - 削除
    │             └─ customer.cacheConstants()
    │
    ├─ cls_formatList
    │      └─ showSelected() - 種別選択肢表示
    │
    ├─ createFCKInstance() - HTMLエディタ生成
    │
    └─ cls_fullSearch
           └─ search() - 使用箇所検索
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォーム入力 ─────▶ getRequestValues() ────▶ オブジェクト
                        │
                        ▼
                    check() ──────────────▶ バリデーション結果
                        │
                        ▼ (OK)
                    save()
                        │
                        ├──▶ tblConstant INSERT/UPDATE
                        │
                        └──▶ cacheConstants()
                                │
                                ▼
                        保存成功メッセージ

既存定数ID ────────▶ pick() ───────────────▶ オブジェクト
                        │
                        ▼
                    search() ─────────────▶ 使用箇所一覧
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_constantEdit.asp | `asp/bs_constantEdit.asp` | ソース | 定数編集メインページ |
| bs_constantTest.asp | `asp/bs_constantTest.asp` | ソース | VBScriptテスト実行 |
| bs_constantList.asp | `asp/bs_constantList.asp` | ソース | 定数一覧（遷移先） |
| bs_scriptList.asp | `asp/bs_scriptList.asp` | ソース | VBScript一覧（遷移先） |
| constant.asp | `asp/includes/constant.asp` | ソース | cls_constantクラス定義 |
| fullsearch.asp | `asp/includes/fullsearch.asp` | ソース | cls_fullSearchクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
