# 機能設計書 96-スクリプト管理

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるスクリプト管理機能の設計を記述する。カスタムASP/VBScriptコードを作成・管理し、テンプレート内で動的なコンテンツを生成するための機能である。

### 本機能の処理概要

スクリプト管理機能は、VBScript種別の定数を専用画面で一覧表示・管理する機能である。

**業務上の目的・背景**：CMSの拡張性を高めるため、管理者がカスタムスクリプトを作成してテンプレート内で実行できる仕組みが必要である。本機能により、データベース連携、外部API呼び出し、動的コンテンツ生成など、標準機能では実現できない高度なカスタマイズが可能となる。VBScriptは高いリスクを伴うため、通常の定数とは別画面で管理し、専用の権限で制御する。

**機能の利用シーン**：カスタム機能の開発時、動的コンテンツ生成のスクリプト作成時、既存スクリプトのメンテナンス時に利用される。

**主要な処理内容**：
1. VBScript種別の定数のみをフィルタリングして一覧表示
2. 各スクリプトの参照用コード（`[スクリプト名]`または`[スクリプト名(パラメータ)]`）の表示
3. スクリプト編集画面へのリンク提供
4. 新規スクリプト作成画面へのリンク提供
5. 通常定数一覧画面へのリンク提供

**関連システム・外部連携**：VBScript内で外部API呼び出しやデータベース操作が可能。

**権限による制御**：セカンドアドミンの`bHomeVBScript`権限を持つユーザーのみアクセス可能。さらに、サイト設定で`bApplication`が有効である必要がある。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 94 | スクリプト一覧 | 主画面 | カスタムASP/VBScriptの一覧表示・管理 |
| 88 | 定数編集 | 遷移先画面 | スクリプト編集画面への遷移 |
| 87 | 定数一覧 | 遷移先画面 | 通常定数一覧画面への遷移 |

## 機能種別

データ参照・一覧表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | 一覧表示のため入力パラメータなし | - |

### 入力データソース

- セッション情報（認証状態）
- tblConstantテーブル（VBScript種別の定数データ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sConstant | String | スクリプト名 |
| sParameters | String | パラメータ定義 |
| iId | Integer | スクリプトID |
| statusString | String | オンライン状態（オンライン/オフライン） |

### 出力先

管理画面（bs_scriptList.asp）のHTMLリストとして表示

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンのbHomeVBScript権限を確認
2. アプリケーション機能チェック
   └─ bApplication設定が無効な場合は定数一覧へリダイレクト
3. ヘッダー情報出力
   └─ ナビゲーションリンク（ページ一覧、新規スクリプト、定数一覧）
4. スクリプトデータ取得
   └─ customer.constantsからVBScript種別のみをフィルタリング
5. 一覧表示
   └─ 各スクリプトの参照コード、編集リンク、状態を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{bHomeVBScript権限チェック}
    B -->|No| C[アクセス拒否]
    B -->|Yes| D{bApplication有効?}
    D -->|No| E[bs_constantList.aspへリダイレクト]
    D -->|Yes| F[ヘッダー・ナビゲーション出力]
    F --> G[定数一覧取得]
    G --> H{定数あり?}
    H -->|No| I[空リスト表示]
    H -->|Yes| J[ループ開始]
    J --> K{iType = VBScript?}
    K -->|No| L[スキップ]
    K -->|Yes| M[スクリプト情報表示]
    M --> N[参照コード表示]
    N --> O[編集リンク]
    O --> P[状態表示]
    L --> Q{次の定数あり?}
    P --> Q
    Q -->|Yes| J
    Q -->|No| R[終了]
    I --> R
    C --> R
    E --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-96-1 | 権限チェック | bHomeVBScript権限を持つセカンドアドミンのみアクセス可能 | 常時 |
| BR-96-2 | アプリケーション機能 | bApplication設定が有効な場合のみスクリプト管理機能を使用可能 | 常時 |
| BR-96-3 | VBScriptフィルタ | VBScript種別（iType=QS_VBScript）の定数のみ表示 | 常時 |
| BR-96-4 | パラメータ表示 | パラメータが定義されている場合は`スクリプト名(パラメータ)`形式で表示 | sParametersが存在する場合 |

### 計算ロジック

- オンライン判定：通常の定数と同様、dOnlineFrom <= 現在日 <= dOnlineUntill

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 一覧取得 | tblConstant | SELECT | VBScript種別の定数取得 |

### テーブル別操作詳細

#### tblConstant

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | iId, sConstant, iType, sParameters, dOnlineFrom, dOnlineUntill | iCustomerID = cId AND iType = QS_VBScript | customer.constants経由でフィルタリング |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アクセス拒否 | bHomeVBScript権限なし | ログインページへリダイレクト |
| - | 機能無効 | bApplication=false | bs_constantList.aspへリダイレクト |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用の処理のため、トランザクション管理は不要

## パフォーマンス要件

- 定数数が100件以下であれば即時レスポンス
- キャッシュされた定数データ（customer.constants）を使用

## セキュリティ考慮事項

- セカンドアドミン権限（bHomeVBScript）による厳格な認証・認可
- bApplication設定による二重のアクセス制御
- VBScriptは任意のサーバーサイドコードを実行可能なため、最小限の権限を持つユーザーのみにアクセスを許可
- 出力時のサニタイズ処理（sanitize関数）

## 備考

- VBScriptはResponse.WriteまたはCustomFunction変数への代入で出力を行う
- エラーハンドリングが実装されており、ランタイムエラーは本番サイトには表示されない（テストモードでのみ表示）
- グローバルコード（関数やクラス定義）をsGlobalフィールドで定義可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_scriptList.asp | `asp/bs_scriptList.asp` | スクリプト一覧のメインファイル |

**主要処理フロー**:
1. **4行目**: セキュリティチェック（`logon.hasaccess secondAdmin.bHomeVBScript`）
2. **4行目**: bApplication設定チェック（`if not customer.bApplication then Response.Redirect`）
3. **5行目**: 新規スクリプト作成リンク（`iType=`&QS_VBScript`）
4. **6-7行目**: 定数一覧の取得（`customer.constants`）
5. **8-9行目**: VBScript種別のフィルタリングとループ処理

**読解のコツ**:
- 新規作成リンクでは`iType=QS_VBScript`パラメータを付与してbs_constantEdit.aspに遷移
- `cconstants(keyconstants).sParameters`が存在する場合、関数呼び出し形式で表示

#### Step 2: 定数クラスの構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | constant.asp | `asp/includes/constant.asp` | cls_constantクラスの定義 |

**VBScript固有のプロパティ**:
- **sParameters**: 関数のパラメータ定義
- **sGlobal**: グローバルコード（関数やクラス定義）

#### Step 3: スクリプトテスト機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_constantTest.asp | `asp/bs_constantTest.asp` | VBScriptテスト実行 |

**主要処理**:
- POSTされたスクリプトコードを別ウィンドウで実行
- エラーハンドリングによる安全な実行環境

### プログラム呼び出し階層図

```
bs_scriptList.asp
    │
    ├─ bs_security.asp
    │      └─ logon.hasaccess(secondAdmin.bHomeVBScript)
    │
    ├─ customer.bApplication チェック
    │      └─ 無効時: bs_constantList.aspへリダイレクト
    │
    └─ customer.constants
           └─ iType = QS_VBScript のフィルタリング
                  └─ 各スクリプトの表示
                         ├─ 参照コード（[名前]または[名前(パラメータ)]）
                         ├─ 編集リンク（bs_constantEdit.asp）
                         └─ 状態表示（statusString）
```

### データフロー図

```
[入力]               [処理]                    [出力]

セッション情報 ───▶ bs_security.asp ───▶ 権限チェック結果
                        │
                        ▼
customer.bApplication ▶ 機能チェック ───▶ リダイレクトまたは続行
                        │
                        ▼
tblConstant ─────▶ customer.constants ──▶ 全定数Dictionary
(キャッシュ)            │
                        ▼
                  iType=VBScriptフィルタ
                        │
                        ▼
               HTMLリスト出力 ─────────▶ スクリプト一覧画面
                        │
                        ├──▶ 参照コードテキストボックス
                        ├──▶ 編集リンク
                        └──▶ 状態表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_scriptList.asp | `asp/bs_scriptList.asp` | ソース | スクリプト一覧メインページ |
| bs_constantEdit.asp | `asp/bs_constantEdit.asp` | ソース | スクリプト編集画面 |
| bs_constantTest.asp | `asp/bs_constantTest.asp` | ソース | VBScriptテスト実行 |
| bs_constantList.asp | `asp/bs_constantList.asp` | ソース | 通常定数一覧（遷移先） |
| constant.asp | `asp/includes/constant.asp` | ソース | cls_constantクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
