# 機能設計書 97-バックオフィス検索

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるバックオフィス検索機能の設計を記述する。管理画面内でページ、定数、フォーム、テンプレート等のコンテンツを横断的に検索するための機能である。

### 本機能の処理概要

バックオフィス検索機能は、サイト管理者が管理画面内のあらゆるコンテンツを一括で検索できる機能である。

**業務上の目的・背景**：大規模なサイト運営において、多数のページ、テンプレート、フォーム、定数などが存在する場合、目的のコンテンツを素早く見つけることは運用効率に大きく影響する。本機能により、キーワードを入力するだけで関連するすべてのコンテンツを横断的に検索でき、編集画面へ直接遷移できる。

**機能の利用シーン**：特定の文言を含むページを探す際、定数の使用箇所を確認する際、フォームフィールドの設定を探す際、テンプレートの修正箇所を特定する際に利用される。

**主要な処理内容**：
1. 検索キーワードの入力受付とCSRF検証
2. 正規表現パターンによる全文検索
3. 複数のコンテンツタイプ（ページ、定数、フォーム、テンプレート等）を対象とした検索
4. 検索結果のカテゴリ別グループ化表示
5. 各検索結果から編集画面への直接リンク提供

**関連システム・外部連携**：外部システムとの連携なし。

**権限による制御**：セカンドアドミンはアクセス不可（管理者パスワードでログインしている場合のみ利用可能）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | 検索画面 | 主画面 | 管理画面内でのページ・コンテンツ検索 |
| 5 | バックサイトホーム | 遷移元画面 | 検索機能へのリンク |

## 機能種別

データ検索・全文検索

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| svalue | String | Yes | 検索キーワード | 空白不可、required属性 |
| postback | Boolean | Yes | ポストバックフラグ | true/false |
| セキュリティトークン | String | Yes | CSRFトークン | トークン検証 |

### 入力データソース

- フォーム入力（検索キーワード）
- セッション情報（認証状態）
- 複数テーブル（検索対象コンテンツ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| カテゴリ | String | 検索結果のカテゴリ（ページ、定数、フォーム等） |
| 項目名 | String | 検索にヒットした項目の名前 |
| 編集リンク | URL | 該当項目の編集画面へのリンク |

### 出力先

管理画面（bs_search.asp）のHTMLテーブルとして表示

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ セカンドアドミンパスワードの場合はリダイレクト
2. 検索フォーム表示
   └─ 検索キーワード入力フィールドとボタン
3. ポストバック判定
   └─ 検索実行時はCSRF検証
4. 検索実行
   └─ cls_fullSearchクラスで正規表現検索
5. 結果表示
   └─ カテゴリ別にグループ化して表示
   └─ 結果なしの場合は0件メッセージ
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{セカンドアドミン?}
    B -->|Yes| C[bs_default.aspへリダイレクト]
    B -->|No| D[検索フォーム表示]
    D --> E{postback & svalue入力あり?}
    E -->|No| F[フォーム待機]
    E -->|Yes| G[CSRFチェック]
    G --> H[cls_fullSearch初期化]
    H --> I[正規表現パターン設定]
    I --> J[search実行]
    J --> K{結果あり?}
    K -->|No| L[0件メッセージ表示]
    K -->|Yes| M[カテゴリ別結果表示]
    M --> N[終了]
    L --> N
    F --> N
    C --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-97-1 | セカンドアドミン制限 | セカンドアドミンパスワードでのアクセス不可 | 常時 |
| BR-97-2 | 必須入力 | 検索キーワードは必須（HTML required属性） | 検索実行時 |
| BR-97-3 | CSRF検証 | 検索実行時はCSRFトークン検証必須 | postback時 |
| BR-97-4 | 正規表現エスケープ | 検索キーワード内の括弧は正規表現用にエスケープ | 検索実行時 |

### 計算ロジック

- 検索パターン生成：`treatParentheses(svalue)`で括弧をエスケープ後、`("キーワード")`形式で正規表現化

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 設定検索 | tblCustomer | SELECT | サイト設定フィールドの検索 |
| ページ検索 | tblPage | SELECT | ページコンテンツの検索 |
| 定数検索 | tblConstant | SELECT | 定数の検索 |
| フォーム検索 | tblForm | SELECT | フォームの検索 |
| フォームフィールド検索 | tblFormField | SELECT | フォームフィールドの検索 |
| テンプレート検索 | tblTemplate | SELECT | テンプレートの検索 |
| フィード検索 | tblFeed | SELECT | RSSフィードの検索 |
| 投票検索 | tblPoll | SELECT | 投票の検索 |
| ギャラリー検索 | tblGallery | SELECT | ギャラリーの検索 |
| テーマ検索 | tblTheme | SELECT | テーマ/フォーラムの検索 |
| カタログフィールド検索 | tblCatalogField | SELECT | カタログフィールドの検索 |
| イントラネットメッセージ検索 | tblCustomerIntranetMessage | SELECT | イントラネットメッセージの検索 |

### テーブル別操作詳細

各テーブルに対して、全フィールドを対象に正規表現パターンマッチを実行

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アクセス拒否 | セカンドアドミンパスワードでのアクセス | bs_default.aspへリダイレクト |
| - | CSRF検証失敗 | トークン不一致 | エラーメッセージ表示 |
| - | 検索結果なし | 該当コンテンツなし | 0件メッセージ表示 |

### リトライ仕様

検索キーワードを変更して再検索可能

## トランザクション仕様

読み取り専用の処理のため、トランザクション管理は不要

## パフォーマンス要件

- 検索は全テーブルに対して順次実行されるため、コンテンツ量に比例して処理時間が増加
- 正規表現検索のため、単純なLIKE検索より負荷が高い

## セキュリティ考慮事項

- 管理者パスワードによる認証（セカンドアドミン不可）
- CSRFトークン検証
- 入力値のサニタイズ処理（sanitize、treatParentheses関数）
- 検索結果表示時のサニタイズ（treatConstants関数）

## 備考

- 検索対象はサイト内の主要なコンテンツタイプを網羅
- 検索結果から各項目の編集画面に直接遷移可能
- 検索キーワードは入力フィールドに自動フォーカス

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_search.asp | `asp/bs_search.asp` | バックオフィス検索のメインファイル |

**主要処理フロー**:
1. **4行目**: セカンドアドミン制限チェック
2. **4行目**: 検索フォームの説明文表示
3. **5行目**: 検索フォーム（svalue入力、CSRFトークン）
4. **6-7行目**: postback判定とキーワード存在チェック
5. **8行目**: CSRFチェック
6. **9-11行目**: cls_fullSearch初期化と正規表現パターン設定
7. **12-18行目**: 検索実行と結果表示

**読解のコツ**:
- `treatParentheses`関数で検索キーワード内の括弧を正規表現エスケープ
- 検索結果が空の場合は`isLeeg`関数でチェック

#### Step 2: 検索ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fullsearch.asp | `asp/includes/fullsearch.asp` | cls_fullSearchクラス |

**主要処理フロー**:
- **2-12行目**: クラス初期化（正規表現オブジェクト作成）
- **16-78行目**: customerfields関数（サイト設定の検索）
- **79-93行目**: pages関数（ページの検索）
- **94-108行目**: constants関数（定数の検索）
- **109-138行目**: forms関数、formFields関数
- **139-213行目**: その他のコンテンツタイプ検索
- **265-400行目**: search関数（メイン検索処理、結果の集約）

#### Step 3: 検索対象カテゴリを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fullsearch.asp | `asp/includes/fullsearch.asp` | search関数内の各カテゴリ処理 |

**検索カテゴリ**:
- **Setup（設定）**: tblCustomer
- **Pages（ページ）**: tblPage
- **Constants（定数）**: tblConstant
- **Forms（フォーム）**: tblForm
- **Form Fields**: tblFormField
- **Templates**: tblTemplate
- **Feeds**: tblFeed
- **Polls**: tblPoll
- **Galleries**: tblGallery
- **Themes**: tblTheme
- **Catalog Fields**: tblCatalogField
- **Intranet Messages**: tblCustomerIntranetMessage

### プログラム呼び出し階層図

```
bs_search.asp
    │
    ├─ セカンドアドミンチェック
    │      └─ currentPW = secondAdmin.sPassword → リダイレクト
    │
    ├─ checkCSRF()
    │
    └─ cls_fullSearch
           ├─ pattern設定（treatParentheses経由）
           │
           └─ search()
                  ├─ customerfields() → tblCustomer
                  ├─ pages() → tblPage
                  ├─ constants() → tblConstant
                  ├─ forms() → tblForm
                  ├─ formFields() → tblFormField
                  ├─ templates() → tblTemplate
                  ├─ feeds() → tblFeed
                  ├─ polls() → tblPoll
                  ├─ galleries() → tblGallery
                  ├─ themes() → tblTheme
                  ├─ catFields() → tblCatalogField
                  └─ Imessages() → tblCustomerIntranetMessage
```

### データフロー図

```
[入力]               [処理]                    [出力]

検索キーワード ────▶ treatParentheses() ────▶ 正規表現パターン
                        │
                        ▼
                  cls_fullSearch.search()
                        │
                        ├──▶ customerfields() ──▶ 設定検索結果
                        ├──▶ pages() ──────────▶ ページ検索結果
                        ├──▶ constants() ──────▶ 定数検索結果
                        ├──▶ forms() ──────────▶ フォーム検索結果
                        ├──▶ templates() ──────▶ テンプレート検索結果
                        └──▶ ... その他 ...
                                │
                                ▼
                        カテゴリ別HTMLテーブル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_search.asp | `asp/bs_search.asp` | ソース | バックオフィス検索メインページ |
| fullsearch.asp | `asp/includes/fullsearch.asp` | ソース | cls_fullSearchクラス定義 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | 管理画面ヘッダー |
