# 機能設計書 98-ページ検証

## 概要

本ドキュメントは、QuickerSite CMSの管理画面におけるページ検証機能の設計を記述する。イントラネットユーザーによるページ編集内容を管理者が承認・検証するためのワークフロー機能である。

### 本機能の処理概要

ページ検証機能は、イントラネット会員がページを編集した際に、その変更内容を管理者が確認・承認するためのワークフロー機能である。

**業務上の目的・背景**：企業のイントラネットサイトや会員制サイトにおいて、一般ユーザーにページ編集権限を与える場合、品質管理の観点から管理者による承認プロセスが必要となる。本機能により、ユーザーが行った変更を管理者がレビューし、承認または却下することで、サイトコンテンツの品質と一貫性を維持できる。

**機能の利用シーン**：イントラネット会員がページを編集した後の管理者によるレビュー時、変更内容の承認または却下時、承認後のユーザーへの通知時に利用される。

**主要な処理内容**：
1. 検証待ちページの一覧表示（bs_validatepages.asp）
2. 個別ページの変更内容表示と比較（bs_validatepage.asp）
3. タイトル変更の承認または却下
4. 本文変更の承認または却下
5. 承認後のメール通知送信

**関連システム・外部連携**：メールシステムとの連携（承認通知メール送信）。

**権限による制御**：管理者またはセカンドアドミン権限を持つユーザーのみアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 19 | ページ検証 | 主画面 | ページのHTML検証処理（単一ページ） |
| 20 | 複数ページ検証 | 一覧画面 | 複数ページの一括HTML検証 |

## 機能種別

ワークフロー管理・承認処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | String(暗号化) | Yes | 対象ページID | 復号化後に数値チェック |
| btnValidate | String | No | アクション種別 | 固定値リスト |
| sTitleToBeValidated | String | No | 新しいタイトル（承認用） | 文字列長チェック |
| sValueToBeValidated | String | No | 新しい本文（承認用） | - |

### 入力データソース

- フォーム入力（承認アクション）
- tblPageテーブル（ページデータ、検証待ち項目）
- tblContactテーブル（編集者情報）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 現在のタイトル | String | 公開中のページタイトル |
| 新しいタイトル | String | 検証待ちの新タイトル |
| 現在の本文 | String | 公開中のページ本文 |
| 新しい本文 | String | 検証待ちの新本文 |
| 編集者情報 | String | 編集したユーザーのニックネーム |
| 編集日時 | DateTime | 編集が行われた日時 |

### 出力先

- tblPage（ページデータ更新）
- メール送信（承認通知）
- 管理画面（検証フォーム表示）

## 処理フロー

### 処理シーケンス

```
1. セキュリティチェック
   └─ 管理者またはセカンドアドミン権限を確認
2. ページデータ取得
   └─ 対象ページの現在データと検証待ちデータを取得
3. アクション分岐
   └─ Save and Validate New Title：タイトル承認
   └─ Remove New Title：タイトル却下
   └─ Save and Validate New Text：本文承認
   └─ Remove New Text：本文却下
4. データ更新
   └─ 承認時：本番データを検証待ちデータで上書き
   └─ 却下時：検証待ちデータをクリア
5. メール送信（承認時）
   └─ 編集者へ承認完了通知を送信
6. フォーム再表示
   └─ 残りの検証待ち項目を表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[セキュリティチェック]
    B --> C[ページデータ取得]
    C --> D{btnValidate判定}
    D -->|Save and Validate New Title| E[タイトル承認処理]
    D -->|Remove New Title| F[タイトル却下処理]
    D -->|Save and Validate New Text| G[本文承認処理]
    D -->|Remove New Text| H[本文却下処理]
    D -->|なし| I[フォーム表示のみ]
    E --> J[sTitleToBeValidated → sTitle]
    F --> K[sTitleToBeValidated = null]
    G --> L[sValueToBeValidated → sValue]
    H --> M[sValueToBeValidated = null]
    J --> N[メール送信]
    L --> N
    K --> O[保存]
    M --> O
    N --> O
    O --> P[成功メッセージ]
    P --> Q[フォーム再表示]
    I --> Q
    Q --> R[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-98-1 | 権限チェック | 管理者またはセカンドアドミンのみ検証可能 | 常時 |
| BR-98-2 | 承認通知 | タイトルまたは本文の承認時に編集者へメール通知 | 承認アクション実行時 |
| BR-98-3 | 確認ダイアログ | 承認・却下の各操作時に確認ダイアログを表示 | ボタンクリック時 |
| BR-98-4 | 部分承認 | タイトルと本文は個別に承認・却下可能 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ取得 | tblPage | SELECT | 検証対象ページの取得 |
| タイトル承認 | tblPage | UPDATE | sTitle更新、sTitleToBeValidatedクリア |
| タイトル却下 | tblPage | UPDATE | sTitleToBeValidatedクリア |
| 本文承認 | tblPage | UPDATE | sValue更新、sValueToBeValidatedクリア |
| 本文却下 | tblPage | UPDATE | sValueToBeValidatedクリア |
| 編集者取得 | tblContact | SELECT | 通知先メールアドレス取得 |
| 検証待ち一覧 | tblPage | SELECT | 検証待ちページの一覧取得 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | sTitle, sValue, sTitleToBeValidated, sValueToBeValidated, iUpdatedBy, dUpdatedOn | iId = 指定ID | pick関数経由 |
| UPDATE | sTitle | sTitleToBeValidated | タイトル承認時 |
| UPDATE | sTitleToBeValidated | null | タイトル承認/却下時 |
| UPDATE | sValue | sValueToBeValidated | 本文承認時 |
| UPDATE | sValueToBeValidated | null | 本文承認/却下時 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アクセス拒否 | 権限なし | ログインページへリダイレクト |
| fb_saveOK | 保存成功 | 正常完了 | 成功メッセージ表示 |

### リトライ仕様

保存失敗時はフォームを再表示し、再操作可能

## トランザクション仕様

- 単一テーブルへの操作のため、ADOの暗黙的トランザクション管理で十分

## パフォーマンス要件

- 検証待ちページ数が100件以下であれば即時レスポンス
- メール送信は同期処理のため、SMTP応答時間に依存

## セキュリティ考慮事項

- 管理者権限による認証・認可
- HTMLエディタ（FCK）によるリッチテキスト編集
- メール送信時のHTML本文はサニタイズ不要（管理者が承認するコンテンツ）

## 備考

- 検証待ちデータはsTitleToBeValidated、sValueToBeValidatedフィールドに保存
- 編集者情報はiUpdatedByフィールドでtblContactと関連付け
- 承認通知メールにはページへの直接リンクを含む

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 検証待ち一覧画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bs_validatepages.asp | `asp/bs_validatepages.asp` | 検証待ちページ一覧 |

**主要処理フロー**:
1. **4行目**: セキュリティチェック
2. **5行目**: 検証待ちページ一覧取得（`customer.pagesTobeValidated`）
3. **5-8行目**: 各ページのリンクと編集者情報を表示

**読解のコツ**:
- `customer.pagesTobeValidated`プロパティでsTitleToBeValidatedまたはsValueToBeValidatedが設定されているページを取得
- `pobj.updater`プロパティでiUpdatedByから編集者情報を取得

#### Step 2: 個別検証画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | bs_validatepage.asp | `asp/bs_validatepage.asp` | 個別ページ検証画面 |

**主要処理フロー**:
1. **4-6行目**: セキュリティチェックとページデータ取得
2. **7-32行目**: アクション分岐（4種類のボタンアクション）
3. **33-44行目**: sendMailToContact関数（承認通知メール送信）
4. **46-48行目**: タイトル検証フォームの条件付き表示
5. **48行目**: 本文検証フォームの条件付き表示（FCKエディタ使用）

**アクション一覧**:
- `Save and Validate New Title`：タイトル承認
- `Remove New Title`：タイトル却下
- `Save and Validate New Text`：本文承認
- `Remove New Text`：本文却下

#### Step 3: メール送信ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bs_validatepage.asp | `asp/bs_validatepage.asp` | sendMailToContact関数 |

**主要処理フロー**:
- **33-44行目**: 関数定義
- **35-36行目**: cls_contactで編集者情報取得
- **37-42行目**: cls_mail_messageでメール作成・送信

### プログラム呼び出し階層図

```
bs_validatepages.asp（一覧画面）
    │
    ├─ customer.pagesTobeValidated
    │      └─ tblPage SELECT (sTitleToBeValidated/sValueToBeValidated is not null)
    │
    └─ bs_validatepage.asp（個別画面）へのリンク

bs_validatepage.asp（個別画面）
    │
    ├─ cls_page
    │      └─ pick(iId) - ページデータ取得
    │
    ├─ btnValidate分岐
    │      ├─ タイトル承認 → sTitle = sTitleToBeValidated
    │      ├─ タイトル却下 → sTitleToBeValidated = null
    │      ├─ 本文承認 → sValue = sValueToBeValidated
    │      └─ 本文却下 → sValueToBeValidated = null
    │
    ├─ sendMailToContact()
    │      ├─ cls_contact.pick(iUpdatedBy)
    │      └─ cls_mail_message.send()
    │
    └─ createFCKInstance（本文編集用）
```

### データフロー図

```
[入力]               [処理]                    [出力]

ページID ──────────▶ cls_page.pick() ────────▶ ページデータ
                        │
                        ▼
btnValidate ─────────▶ アクション分岐
                        │
        ┌───────────────┼───────────────┐
        ▼               ▼               ▼
    タイトル承認     タイトル却下     本文承認/却下
        │               │               │
        ▼               ▼               ▼
    sTitle更新      ToBeValidated    sValue更新
        │           =null            /ToBeValidated=null
        │               │               │
        ▼               │               ▼
    メール送信 ◀────────┴───────────▶ メール送信
        │                               │
        └───────────────┬───────────────┘
                        ▼
                   保存・画面更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bs_validatepage.asp | `asp/bs_validatepage.asp` | ソース | 個別ページ検証画面 |
| bs_validatepages.asp | `asp/bs_validatepages.asp` | ソース | 検証待ちページ一覧 |
| bs_security.asp | `asp/bs_security.asp` | ソース | セキュリティチェック |
| header.asp | `asp/includes/header.asp` | テンプレート | HTMLヘッダー |
| bs_header.asp | `asp/bs_header.asp` | テンプレート | 管理画面ヘッダー |
