# 機能設計書 99-ページ表示

## 概要

本ドキュメントは、QuickerSite CMSのフロントエンドにおけるページ表示機能の設計を記述する。公開サイトのページをレンダリングし、訪問者に表示するための中核機能である。

### 本機能の処理概要

ページ表示機能は、訪問者がアクセスしたURLに対応するページコンテンツを取得し、テンプレートを適用してHTMLを生成・表示する機能である。

**業務上の目的・背景**：CMSの最も基本的な機能として、管理画面で作成されたコンテンツを訪問者に適切に表示することは不可欠である。本機能により、ページ認証、テンプレート適用、定数置換、各種コンポーネント（フォーム、カタログ、フィード等）の統合、アクセス統計の記録など、公開サイトの表示に必要なすべての処理を統合的に実行する。

**機能の利用シーン**：訪問者がサイトのページにアクセスした際、検索エンジンがクロールした際、RSS経由でアクセスがあった際に利用される。

**主要な処理内容**：
1. URLパラメータまたはユーザーフレンドリーURLによるページ特定
2. パスワード保護・イントラネット認証チェック
3. ページコンテンツの取得とテンプレート適用
4. 定数・変数の置換処理
5. フォーム、カタログ、フィード、テーマ等のコンポーネント組み込み
6. ヒット数・訪問者数の記録
7. HTML出力

**関連システム・外部連携**：
- RSSフィード出力
- 外部URLリダイレクト
- テンプレートエンジン

**権限による制御**：パスワード保護ページはパスワード認証が必要。イントラネットページは会員認証が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 158 | トップページ | 主画面 | サイトトップページのレンダリング・表示 |
| 159 | インデックス | リダイレクト画面 | サイトインデックスへのリダイレクト処理 |
| 173 | アイテム表示処理 | 表示処理 | アイテム詳細ページの表示処理 |
| 174 | 投稿表示処理 | 表示処理 | 投稿詳細ページの表示処理 |

## 機能種別

ページレンダリング・コンテンツ配信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| iId | String(暗号化) | No | ページID（クエリストリング） | 復号化後に数値チェック |
| sCode | String | No | ショートコード（UFL用） | 文字列チェック |
| pageAction | String | No | アクション種別 | 固定値リスト |
| item | String(暗号化) | No | リストアイテムID | 復号化後に数値チェック |
| iPostID | String(暗号化) | No | 投稿ID | 復号化後に数値チェック |

### 入力データソース

- URLパラメータ
- セッション情報（認証状態）
- Cookieデータ（パスワード認証）
- tblPageテーブル（ページデータ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pageTitle | String | ページタイトル |
| pageBody | String | ページ本文（テンプレート適用後） |
| pageSiteMap | String | サイトマップリンク |
| pageSearch | String | 検索リンク |
| pageRSS | String | RSSリンク |
| pageForm | String | フォームHTML |
| pageCatalog | String | カタログHTML |
| pageFeed | String | フィードHTML |
| pageTheme | String | テーマ/フォーラムHTML |

### 出力先

- HTTPレスポンス（HTML）
- tblPage（ヒット数・訪問者数の更新）

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ デフォルトパスワードチェック（初期設定未完了の場合はログイン画面へ）
2. モバイルブラウザ判定
   └─ モバイル用表示の切り替え
3. ページ特定
   └─ iIdまたはユーザーフレンドリーURLでページを特定
4. pageAction分岐
   └─ 各種アクション（検索、投票、ログイン等）への振り分け
5. 認証チェック
   └─ パスワード保護・イントラネット認証の確認
6. ページタイプ別処理
   └─ コンテナページ：最初の子ページへ移動
   └─ 外部URL：リダイレクト
   └─ コンテンツページ：本文表示
7. コンポーネント組み込み
   └─ リストページ、フォーム、カタログ、フィード、テーマの処理
8. 統計記録
   └─ ヒット数・訪問者数の加算
9. テンプレート適用
   └─ buildTemplate()でHTML生成
10. 出力
    └─ HTTPレスポンス
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B{デフォルトPWチェック}
    B -->|初期設定未完了| C[ログイン画面へ]
    B -->|OK| D[モバイル判定]
    D --> E{iIdあり?}
    E -->|No| F[UFL検索]
    E -->|Yes| G[ページ取得]
    F --> G
    G --> H{pageAction?}
    H -->|search| I[検索処理]
    H -->|login| J[ログイン処理]
    H -->|vote| K[投票処理]
    H -->|その他| L[ページ表示処理]
    L --> M{認証必要?}
    M -->|Yes| N{認証済み?}
    N -->|No| O[認証画面へ]
    N -->|Yes| P[ページタイプ判定]
    M -->|No| P
    P -->|コンテナ| Q[子ページへ移動]
    P -->|外部URL| R[リダイレクト]
    P -->|コンテンツ| S[本文取得]
    Q --> S
    S --> T[コンポーネント組み込み]
    T --> U[統計記録]
    U --> V[テンプレート適用]
    V --> W[HTML出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-99-1 | デフォルトPWチェック | 初期パスワードのままの場合は管理画面へ誘導 | 常時（devVersion時は除外） |
| BR-99-2 | パスワード保護 | パスワード設定ページは認証必須 | sPwが設定されている場合 |
| BR-99-3 | イントラネット認証 | イントラネットページは会員認証必須 | bIntranet=true |
| BR-99-4 | オフラインページ | オフラインページは管理者のみ表示可能 | bOnline=false |
| BR-99-5 | 削除ページ | 削除済みページはホームページにリダイレクト | bDeleted=true |
| BR-99-6 | コンテナページ | コンテナページは最初の子ページに自動遷移 | bContainerPage=true |
| BR-99-7 | 外部URL | 外部URLページは設定先にリダイレクト | sExternalURLが設定されている場合 |

### 計算ロジック

- ヒット数：ページ表示ごとに+1
- 訪問者数：セッション内で初回アクセス時のみ+1

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ページ取得 | tblPage | SELECT | ページデータの取得 |
| ヒット数更新 | tblPage | UPDATE | iHitsの加算 |
| 訪問者数更新 | tblPage | UPDATE | iVisitorsの加算 |
| テンプレート取得 | tblTemplate | SELECT | テンプレートHTML/CSSの取得 |
| フォーム取得 | tblForm | SELECT | 関連フォームの取得 |
| カタログ取得 | tblCatalog | SELECT | 関連カタログの取得 |

### テーブル別操作詳細

#### tblPage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | iId = 指定ID / sUserFriendlyURL = 指定UFL | selectedPage経由 |
| UPDATE | iHits | iHits + 1 | AddHit()メソッド |
| UPDATE | iVisitors | iVisitors + 1 | addVisit()メソッド（セッション初回のみ） |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | ページ不存在 | 指定ページが見つからない | 404ページ表示またはホームへリダイレクト |
| - | 認証要求 | パスワード/イントラネット認証未完了 | 認証画面へリダイレクト |

### リトライ仕様

特になし（認証失敗時は認証画面を再表示）

## トランザクション仕様

- ヒット数・訪問者数の更新は個別UPDATE文で実行
- 厳密な一貫性は不要（統計目的のため）

## パフォーマンス要件

- 通常ページの表示は1秒以内
- キャッシュ機能（showFromCache）による高速化
- テンプレートと定数はキャッシュ済みデータを使用

## セキュリティ考慮事項

- パスワード保護によるアクセス制御
- イントラネット認証による会員限定コンテンツ保護
- CSRFトークン検証（ログオフ処理時）
- XSS対策（quotRep、sanitize関数）
- SQLインジェクション対策（パラメータ検証）

## 備考

- ユーザーフレンドリーURL（UFL）対応により、SEOに配慮したURL構造が可能
- 404エラー時はカスタム404ページを表示可能
- モバイルブラウザ自動判定によるレスポンシブ対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | default.asp | `default.asp` | サイトルートのエントリーポイント |
| 1-2 | process.asp | `asp/process.asp` | メイン処理ロジック |

**主要処理フロー**:
1. **2-6行目**: デフォルトパスワードチェック
2. **8行目**: モバイルブラウザ判定（`checkMobileBrowser()`）
3. **10-12行目**: UFL検索（`selectedPage.pickByUserFriendlyURL()`）
4. **40-167行目**: pageAction分岐（select case）
5. **183-265行目**: ページタイプ別処理
6. **268-269行目**: 統計記録（`AddHit()`、`addVisit()`）
7. **279行目**: テンプレート適用（`selectedPage.buildTemplate()`）

**読解のコツ**:
- `selectedPage`はグローバル変数で、現在表示中のページオブジェクト
- pageActionによる多数の分岐があるが、通常のページ表示はcase else部分

#### Step 2: pageAction分岐を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | process.asp | `asp/process.asp` | 40-167行目のselect case |

**主要なpageAction**:
- `avataredit`, `fileupload`：ファイル操作
- `unsubscribe`, `send`, `showpost`, `showitem`：各種表示処理
- `sitemap`, `itemform`, `search`：インクルードファイル呼び出し
- `vote`, `voteshowresults`, `voteshowballot`：投票機能
- `showpopup`：ポップアップ表示
- `gbedit`：ゲストブック操作
- `editsite`：フロントエンド編集
- `login`, `loginIntranet`, `register`, `forgotPW`, `profile`：認証関連
- `logOff`：ログアウト

#### Step 3: 認証チェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | process.asp | `asp/process.asp` | 219-265行目 |

**認証フロー**:
- **219行目**: `logon.logonItem()`でパスワード認証チェック
- **220-230行目**: イントラネット認証チェック
- **232-256行目**: ページタイプ別処理（コンテナ/外部URL/コンテンツ）

### プログラム呼び出し階層図

```
default.asp
    │
    ├─ asp/begin.asp（初期化）
    │
    └─ asp/process.asp
           │
           ├─ checkMobileBrowser()
           │
           ├─ selectedPage.pickByUserFriendlyURL()（UFL時）
           │
           ├─ pageAction分岐
           │      ├─ process_search.asp
           │      ├─ process_login.asp
           │      ├─ process_loginIntranet.asp
           │      ├─ process_register.asp
           │      ├─ process_catalog.asp
           │      └─ ... その他インクルード
           │
           ├─ logon.logonItem()（認証チェック）
           │
           ├─ ページタイプ別処理
           │      ├─ moveToFirstSubItem()（コンテナ）
           │      ├─ Response.Redirect()（外部URL）
           │      └─ process_listpage.asp（リストページ）
           │
           ├─ コンポーネント組み込み
           │      ├─ selectedPage.form.build()
           │      ├─ selectedPage.theme.build()
           │      ├─ process_catalog.asp
           │      └─ selectedPage.Feed.build()
           │
           ├─ selectedPage.AddHit()
           ├─ selectedPage.addVisit()
           │
           └─ selectedPage.buildTemplate()
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ─────▶ ページ特定 ─────────────▶ selectedPage
(iId/UFL)               │
                        ▼
Cookie/Session ────▶ 認証チェック ───────────▶ 認証結果
                        │
                        ▼
tblPage ───────────▶ ページデータ取得 ────────▶ pageTitle/pageBody
                        │
                        ▼
tblForm/tblCatalog ▶ コンポーネント取得 ────▶ pageForm/pageCatalog
                        │
                        ▼
tblTemplate ───────▶ テンプレート適用 ────────▶ HTML出力
                        │
                        ▼
                   統計記録 ─────────────────▶ tblPage UPDATE
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| default.asp | `default.asp` | ソース | サイトルートエントリーポイント |
| process.asp | `asp/process.asp` | ソース | メイン処理ロジック |
| process_listpage.asp | `asp/process_listpage.asp` | ソース | リストページ処理 |
| process_catalog.asp | `asp/process_catalog.asp` | ソース | カタログ処理 |
| process_search.asp | `asp/process_search.asp` | ソース | 検索処理 |
| process_login.asp | `asp/process_login.asp` | ソース | ログイン処理 |
| process_loginIntranet.asp | `asp/process_loginIntranet.asp` | ソース | イントラネットログイン処理 |
| begin.asp | `asp/begin.asp` | ソース | 初期化処理 |
