---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-管理者ログイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **セッションタイムアウト値の根拠**：設定ファイルでの定義確認が必要
  2. **試行回数上限のデフォルト値**：web_config.aspでの定義確認が必要
  3. **CAPTCHAの具体的な実装仕様**：コードから導出したが仕様書がない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_login.asp` - ログイン画面メインファイル（29行）
- E-02: `asp/includes/LogonEdit.asp` - cls_LogonEditクラス（241行）
- E-03: `asp/includes/captcha.asp` - CAPTCHA画像生成（413行）
- E-04: `asp/includes/secondAdmin.asp` - cls_secondAdminクラス（233行）
- E-05: `asp/includes/customer.asp` - cls_customerクラス（1637行）
- E-06: `asp/begin.asp` - 共通初期化（204行）
- E-07: `asp/bs_security.asp` - セキュリティチェック（79行）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パスワードとCAPTCHAによる二要素認証 | E-01（9-12行目）、E-03 | ○ |
| C-02 | SHA-256でパスワードをハッシュ化 | E-01（12行目: sha256()）、E-02（22-44行目） | ○ |
| C-03 | ログイン試行回数制限あり | E-01（24行目）、E-02（86-98行目: lockBSAdmin） | ○ |
| C-04 | CAPTCHA検証はセッション値と比較 | E-01（9行目）、E-03（407行目） | ○ |
| C-05 | セカンドアドミンは制限された権限 | E-04（全体）、E-07（17-75行目） | ○ |
| C-06 | デフォルトパスワード使用時は初期設定へリダイレクト | E-07（76-78行目） | ○ |
| C-07 | Cookieモードでパスワードハッシュを保存 | E-02（29-31行目） | ○ |
| C-08 | IP単位でログイン試行をカウント | E-01（24行目: application("bsLoginCount"&UserIP)） | ○ |
| C-09 | 試行回数超過時に管理者へメール通知 | E-02（77-80行目: dumpError） | ○ |
| C-10 | セッション認証フラグはSession(cId & "isAUTHENTICATED") | E-02（27行目） | ○ |
| C-11 | CAPTCHA画像は4文字のランダム英数字 | E-03（67行目: CodeLength = 4、75-87行目: CreateGUID） | ○ |
| C-12 | tblCustomerからadminPassword取得 | E-05（122行目） | ○ |
| C-13 | tblSecondAdminからsPassword取得 | E-04（14-17行目） | ○ |
| C-14 | ログイン成功後bs_default.aspへリダイレクト | E-01（14行目） | ○ |
| C-15 | bs_page指定時はそのページへリダイレクト | E-01（15-19行目） | ○ |
| C-16 | CAPTCHA失敗時はerr_captchaエラー | E-01（11行目） | ○ |
| C-17 | パスワード失敗時はerr_loginエラー | E-01（22行目） | ○ |
| C-18 | セッションタイムアウトは30分 | E-06（16行目: session.Timeout = 30） | ○ |
| C-19 | 関連画面No.1,2,113,114,197 | E-09 | ○ |
| C-20 | 機能カテゴリは「管理画面/認証」 | E-08 | ○ |
| C-21 | 主要ファイルはbs_login.asp | E-08 | ○ |
| C-22 | パスワード最大長は50文字 | E-01（28行目: maxlength=50） | ○ |
| C-23 | CAPTCHA入力最大長は4文字 | E-01（28行目: maxlength=4） | ○ |
| C-24 | QS_number_of_allowed_attempts_to_loginで試行上限を設定 | E-02（87,95行目） | ○ |
| C-25 | 試行上限のデフォルト値は特定の数値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- QS_number_of_allowed_attempts_to_loginのデフォルト値
  - 候補：web_config.asp / 設定ドキュメント / コード内ハードコード
  - 対応：web_config.aspを確認して具体的な値を特定する必要あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な認証ロジックは全てソースコードで確認済み
- 0: 低リスク - セキュリティ関連の処理（ハッシュ化、試行制限）は明確
- 1: 中リスク - 設定値（試行上限）のデフォルト値未確認

## 6) レビュアーチェックリスト（最小）
- [ ] SHA-256ハッシュ化の実装が正しいか確認（includes/sha256.asp）
- [ ] CAPTCHA検証ロジックの大文字小文字無視が正しく動作するか確認
- [ ] ログイン試行回数上限値（QS_number_of_allowed_attempts_to_login）の設定値を確認
- [ ] Cookieモード有効時のセキュリティリスク評価
- [ ] セカンドアドミンの権限範囲が設計書と一致しているか確認
