---
generated_at: 2026-01-23 11:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-ページ削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_delete.asp` - 削除ボタン表示（3行）
- E-02: `asp/bs_processPage.asp` - 削除処理（83行）
- E-03: `asp/includes/page.asp` - cls_pageクラス（600行以上）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | canBeDeletedで削除ボタン表示判定 | E-01（2行目: if page.canBeDeleted） | ○ |
| C-02 | JavaScriptでconfirm確認ダイアログ | E-02（3行目: if confirm） | ○ |
| C-03 | CSRF検証を実行 | E-02（27行目: checkCSRF） | ○ |
| C-04 | bDeleted=trueで論理削除 | E-02（28行目: page.bDeleted=true） | ○ |
| C-05 | removeRangで親ページから順位除去 | E-02（29行目: page.parentPage.removeRang(page)） | ○ |
| C-06 | iRang=0で順位リセット | E-02（30行目: page.iRang=0） | ○ |
| C-07 | bOnline=falseでオンライン解除 | E-02（31行目: page.bOnline=false） | ○ |
| C-08 | bHomepage=falseでホームページ解除 | E-02（32行目: page.bHomepage=false） | ○ |
| C-09 | deleteListItemsでリストアイテム削除 | E-02（33行目: page.deleteListItems()） | ○ |
| C-10 | page.save()でDB保存 | E-02（34行目） | ○ |
| C-11 | イントラネット時bs_intranet.aspへリダイレクト | E-02（36-37行目: if page.bIntranet） | ○ |
| C-12 | 通常ページ時bs_default.aspへリダイレクト | E-02（38-39行目） | ○ |
| C-13 | リストアイテム時bs_listPage.aspへリダイレクト | E-02（42行目） | ○ |
| C-14 | tblContactPage関連レコード削除 | E-03（590行目: delete from tblContactPage） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ページ削除処理が全てソースコードで確認済み
- 0: 低リスク - 論理削除のためデータ復旧の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 削除確認ダイアログが正しく表示されるか確認
- [ ] 論理削除後にフロントサイトから非表示になるか確認
- [ ] リストアイテム削除が連動して動作するか確認
- [ ] tblContactPage関連レコードが正しく削除されるか確認
- [ ] リダイレクト先が適切か確認
