---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：100-リストページ表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **getAccordeonList()の実装**：アコーディオンモード処理の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process_listpage.asp` - リストページ処理メインファイル
- E-02: `asp/process.asp` - 親処理ファイル（インクルード元）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pageListPage初期化（QS_list DIV） | E-01 2行目 `pageListPage="<div id='QS_list'>"` | ○ |
| C-02 | fastlistitems取得 | E-01 3行目 `for each listItem in selectedPage.fastlistitems` | ○ |
| C-03 | フォーム有無判定 | E-01 4-10行目 `set frm=listItem.form` `if frm.sType<>"" then` | ○ |
| C-04 | 通常モード処理 | E-01 12-81行目 `if not convertBool(selectedPage.bAcc) then` | ○ |
| C-05 | アコーディオンモード処理 | E-01 82-87行目 `else` ブロック、`getAccordeonList()` | ○ |
| C-06 | 外部リンクアイテム判定 | E-01 18行目 `isLPEU=not isLeeg(selectedListItem.sLPExternalURL)` | ○ |
| C-07 | 外部リンク新規ウィンドウ | E-01 26行目 `if convertBool(selectedListItem.bLPExternalOINW)` | ○ |
| C-08 | 展開条件判定 | E-01 36-43行目 複合条件（printReplies, pageCondition, LPCounter等） | ○ |
| C-09 | デフォルト展開数制御 | E-01 38行目 `LPCounter<convertGetal(selectedPage.iLPOpenByDefault)` | ○ |
| C-10 | item=close全折りたたみ | E-01 38行目 `Request.QueryString("item")<>"close"` | ○ |
| C-11 | bOpenOnload全展開 | E-01 39行目 `convertBool(selectedPage.bOpenOnload) and isLeeg(Request.QueryString("item"))` | ○ |
| C-12 | 暗号化アイテムID展開 | E-01 39行目 `Request.QueryString("item")=encryptedListkey` | ○ |
| C-13 | QS_listitem DIV構造 | E-01 27行目 `<div class='QS_listitem'>` | ○ |
| C-14 | QS_listitemtitle DIV構造 | E-01 52行目 `<div class='QS_listitemtitle'>` | ○ |
| C-15 | QS_listitemvalue DIV構造 | E-01 56行目 `<div class='QS_listitemvalue'>` | ○ |
| C-16 | QS_listminusplus DIV構造 | E-01 46行目 `<div class='QS_listminusplus'>` | ○ |
| C-17 | フィード組み込み | E-01 72-74行目 `if convertGetal(selectedListItem.iFeedId)>0 then` `selectedListItem.Feed.build()` | ○ |
| C-18 | 日付表示/非表示制御 | E-01 60-63行目 `if not convertBool(selectedPage.bHideDate) then` | ○ |
| C-19 | 定数置換処理 | E-01 89行目 `pageListPage=treatConstants(pageListPage)` | ○ |
| C-20 | QS_list終了DIV | E-01 90行目 `pageListPage=pageListPage & "</div>"` | ○ |
| C-21 | 機能カテゴリが「フロントエンド/リスト表示」 | E-03 100行目 | ○ |
| C-22 | getAccordeonList()の実装詳細 | **根拠不足** - ページクラスの実装確認が必要 | △ |

## 4) 不足情報（Unknown / Missing）
- getAccordeonList()メソッドの実装（アコーディオン表示用HTML生成ロジック）
  - 候補：asp/includes/page.asp

## 5) リスクフラグ（レビュー観点）
- 0: 展開/折りたたみロジック（ソースコードで確認済み）
- 0: 外部リンク処理（実装確認済み）
- 1: アコーディオンモードの実装詳細（getAccordeonList未確認）
- 0: フィード組み込み（実装確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] 展開条件の複合判定が正しく動作することを確認
- [ ] 外部リンクアイテムのクリック動作を確認
- [ ] アコーディオンモード時のCSS適用状態を確認
- [ ] 大量アイテム時のパフォーマンスを確認
- [ ] フィード組み込み時のエラーハンドリングを確認
