---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：101-カタログ表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値基準の根拠なし
  2. **catalog.aspクラス定義**：直接読み込み未実施
  3. **catalogItem.aspクラス定義**：直接読み込み未実施

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/process_catalog.asp` - カタログ表示メイン処理
- E-02: `asp/process.asp` - ページアクションルーター（249行目）
- E-03: `asp/includes/ItemSearch.asp` - cls_itemSearchクラス定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.101定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.171定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カタログ表示機能はprocess_catalog.aspで実装 | E-01 | ○ |
| C-02 | process.aspの249行目でinclude | E-02 | ○ |
| C-03 | cls_itemSearchクラスで検索処理 | E-03 | ○ |
| C-04 | オンライン状態チェック（bOnline） | E-01 4行目 | ○ |
| C-05 | 検索フォーム生成処理 | E-01 18-45行目 | ○ |
| C-06 | ページネーション機能（browseTable） | E-03 189-206行目 | ○ |
| C-07 | 暗号化パラメータ（encrypt/decrypt） | E-01 20行目 | ○ |
| C-08 | sanitize関数による出力エスケープ | E-01 26行目 | ○ |
| C-09 | 検索キーワードのスペース分割 | E-03 59-65行目 | ○ |
| C-10 | オンライン期間制御 | E-03 67-68行目 | ○ |
| C-11 | ページサイズデフォルト9999 | E-03 26行目 | ○ |
| C-12 | First_Record計算ロジック | E-03 207-209行目 | ○ |
| C-13 | Last_Record計算ロジック | E-03 210-215行目 | ○ |
| C-14 | tblCatalogItem検索 | E-03 52-54行目 | ○ |
| C-15 | フィールドタイプ別表示処理 | E-01 74-83行目 | ○ |
| C-16 | ファイル添付表示 | E-01 89-106行目 | ○ |
| C-17 | フォームリンク生成 | E-01 109-116行目 | ○ |
| C-18 | パフォーマンス要件（レスポンス時間） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値基準
  - 候補：システム要件定義書 / 非機能要件定義書 / 運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な処理フローは全てコードで確認済み
- 1: 中リスク - catalog.asp, catalogItem.aspの詳細実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] process_catalog.aspの処理フローが設計書と一致するか確認
- [ ] cls_itemSearchの検索SQLが設計書記載と一致するか確認
- [ ] ページネーション計算ロジックの正確性確認
- [ ] セキュリティ対策（sanitize, encrypt）の網羅性確認
