---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：102-サイト内検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/process_search.asp` - 検索表示メイン処理（43行）
- E-02: `asp/process.asp` - ページアクションルーター（50行目）
- E-03: `asp/includes/search.asp` - cls_searchクラス定義（171行）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.102定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.165定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 検索機能はprocess_search.aspで実装 | E-01 | ○ |
| C-02 | process.aspの50行目でinclude | E-02 | ○ |
| C-03 | cls_searchクラスで検索処理 | E-03 | ○ |
| C-04 | キーワード最大100文字 | E-01 2行目 | ○ |
| C-05 | 3文字以上必須 | E-03 34行目 | ○ |
| C-06 | 最大250件制限 | E-03 96行目 | ○ |
| C-07 | ダブルクォートでフレーズ検索 | E-03 50-53行目 | ○ |
| C-08 | パスワード保護除外 | E-03 79-81行目 | ○ |
| C-09 | イントラネット認証チェック | E-03 85-87行目 | ○ |
| C-10 | 本文抜粋150文字 | E-01 17行目 | ○ |
| C-11 | キーワードハイライト | E-01 17行目 | ○ |
| C-12 | Cookie保存 | E-03 32行目 | ○ |
| C-13 | tblPage検索 | E-03 55-88行目 | ○ |
| C-14 | tblPost/tblTheme検索 | E-03 114-152行目 | ○ |
| C-15 | リストアイテム検索 | E-03 74-77行目 | ○ |
| C-16 | オンライン期間チェック | E-03 75行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張がコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての処理フローがコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] process_search.aspの処理フローが設計書と一致するか確認
- [ ] cls_searchのSQL構築ロジックが設計書記載と一致するか確認
- [ ] セキュリティ対策（cleanup, sanitize）の適用箇所確認
- [ ] 認証状態によるフィルタ条件の正確性確認
