---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：103-ページログイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/process_login.asp` - ログイン処理メイン（26行）
- E-02: `asp/process.asp` - ページアクションルーター（133行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.103定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.164定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログイン機能はprocess_login.aspで実装 | E-01 | ○ |
| C-02 | process.aspの133行目でinclude | E-02 | ○ |
| C-03 | logon.logonItem()で認証 | E-01 3行目 | ○ |
| C-04 | 認証成功時リダイレクト | E-01 4行目 | ○ |
| C-05 | 認証失敗時err_loginエラー | E-01 6行目 | ○ |
| C-06 | パスワード最大15文字 | E-01 17行目 | ○ |
| C-07 | type="password"で入力マスク | E-01 17行目 | ○ |
| C-08 | encrypt関数でページID暗号化 | E-01 10行目 | ○ |
| C-09 | パスワード問い合わせリンク | E-01 13行目 | ○ |
| C-10 | 自動フォーカス設定 | E-01 25行目 | ○ |
| C-11 | フォームアクション設定 | E-01 9行目 | ○ |
| C-12 | ページタイトル設定 | E-01 26行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張がコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての処理フローがコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] process_login.aspの処理フローが設計書と一致するか確認
- [ ] logon.logonItem()の内部実装確認（LogonEdit.asp）
- [ ] Cookie保存ロジックの確認
- [ ] セキュリティ対策の網羅性確認
