---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：106-パスワード再発行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/process_forgotPW.asp` - パスワード再発行処理メイン（30行）
- E-02: `asp/process.asp` - ページアクションルーター（148-150行目）
- E-03: `asp/includes/contact.asp` - cls_contact.resetPWメソッド（288-306行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.106定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.170定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パスワード再発行はprocess_forgotPW.aspで実装 | E-01 | ○ |
| C-02 | process.aspの148-150行目でinclude | E-02 | ○ |
| C-03 | logon.resetPW()でリセット処理 | E-01 5行目 | ○ |
| C-04 | CAPTCHA検証 | E-01 3-4行目 | ○ |
| C-05 | err_captchaエラー | E-01 4行目 | ○ |
| C-06 | err_emailNotFoundエラー | E-01 8行目 | ○ |
| C-07 | 成功時リダイレクト | E-01 6行目 | ○ |
| C-08 | cls_contact.resetPWメソッド | E-03 288-306行目 | ○ |
| C-09 | GeneratePassWord()でパスワード生成 | E-03 289行目 | ○ |
| C-10 | UPDATE tblContactでパスワード更新 | E-03 291行目 | ○ |
| C-11 | cls_mail_messageでメール送信 | E-03 293-305行目 | ○ |
| C-12 | intranetPWEmailテンプレート使用 | E-03 297-302行目 | ○ |
| C-13 | イントラネット有効チェック | E-02 149行目 | ○ |
| C-14 | 自動フォーカス設定 | E-01 30行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張がコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての処理フローがコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] process_forgotPW.aspの処理フローが設計書と一致するか確認
- [ ] resetPW()のパスワード生成・更新ロジック確認
- [ ] メール送信内容とテンプレートの確認
- [ ] CAPTCHA検証の実装確認
