---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：109-投票機能

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/poll.asp` - cls_pollクラス定義（388行）
- E-02: `asp/process.asp` - ページアクションルーター（61-67行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.109定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 投票はcls_pollクラスで実装 | E-01 | ○ |
| C-02 | process.aspの61-67行目でルーティング | E-02 | ○ |
| C-03 | registerVote()で投票登録 | E-01 299-320行目 | ○ |
| C-04 | canVoteで投票可否判定 | E-01 242-298行目 | ○ |
| C-05 | showresults()で結果表示 | E-01 336-380行目 | ○ |
| C-06 | bIsOnlineチェック | E-01 250-251行目 | ○ |
| C-07 | dVoteDeadlineチェック | E-01 254-259行目 | ○ |
| C-08 | セッション重複チェック | E-01 268-271行目 | ○ |
| C-09 | Cookie重複チェック | E-01 284-287行目 | ○ |
| C-10 | IP制限チェック（6回） | E-01 273-277行目 | ○ |
| C-11 | リセット日時対応 | E-01 278-283行目 | ○ |
| C-12 | tblPollVote INSERT | E-01 305-313行目 | ○ |
| C-13 | セッション更新 | E-01 314行目 | ○ |
| C-14 | Cookie更新（10日） | E-01 315-316行目 | ○ |
| C-15 | 投票率計算ロジック | E-01 361行目 | ○ |
| C-16 | 最大15選択肢 | E-01 359行目 | ○ |
| C-17 | AJAX応答 | E-01 317行目 | ○ |
| C-18 | encrypt関数使用 | E-01 224行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張がコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての処理フローがコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] cls_poll.registerVote()の処理フローが設計書と一致するか確認
- [ ] canVoteの各種チェック条件確認
- [ ] showresults()の集計ロジック確認
- [ ] 重複投票防止の実装確認
- [ ] AJAX通信の実装確認
