---
generated_at: 2026-01-23 21:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-ページ移動・並び替え機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **トランザクション仕様**：明示的なトランザクション制御の有無を要確認
  2. **パフォーマンス要件**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_process.asp` - アクション処理ロジック（20-64行目）
- E-02: `asp/bs_selectPage.asp` - ページ選択画面（4-21行目）
- E-03: `asp/bs_sortorder.asp` - 並び順選択コンポーネント（1-12行目）
- E-04: `asp/includes/page.asp` - cls_pageクラス定義（827-862行目moveUp/moveDown）
- E-05: `asp/includes/menu.asp` - cls_menuクラス定義（237-281行目getReplaceMenu）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MoveUp/MoveDownアクションでページの上下移動が可能 | E-01（20-35行目） | ○ |
| C-02 | Insertアクションで別の親ページ配下への移動が可能 | E-01（41-64行目） | ○ |
| C-03 | CSRF検証がcheckCSRF()で実行される | E-01（21,29,37,42行目） | ○ |
| C-04 | secondAdmin.bPagesMoveで権限チェックされる | E-02（4行目） | ○ |
| C-05 | secondAdmin.bPageOrderで並び順変更権限がチェックされる | E-03（3行目） | ○ |
| C-06 | moveUp()でランクが1の場合は処理をスキップ | E-04（829-830行目） | ○ |
| C-07 | moveDown()でランクが最大の場合は処理をスキップ | E-04（847-848行目） | ○ |
| C-08 | ランク調整SQL内でbIntranetフラグが考慮される | E-04（835-839,853-857行目） | ○ |
| C-09 | clearMenuCache()がランク変更後に呼び出される | E-04（842,860行目） | ○ |
| C-10 | getReplaceMenu()で移動先選択ツリーが生成される | E-05（237-281行目） | ○ |
| C-11 | 移動時に親ページのパスワードが継承される | E-01（55-58行目） | ○ |
| C-12 | 移動時に親ページがオフラインなら対象もオフラインになる | E-01（49-51行目） | ○ |
| C-13 | フリーページ移動時にbLossePaginaがfalseになる | E-01（48行目） | ○ |
| C-14 | 画面No.16がページ選択画面として対応 | E-07（29行目） | ○ |
| C-15 | 入力パラメータiIdは暗号化されている | E-02（5行目encrypt関数使用） | ○ |
| C-16 | 機能Noが11でページ移動・並び替えとして定義 | E-06（12行目） | ○ |
| C-17 | 明示的なトランザクション制御は行われていない | **根拠なし** | △ |
| C-18 | レスポンス時間は通常1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- トランザクション制御に関する明示的なコードや設定ファイルが見つからないため、ADODBのデフォルト動作を前提として記載
  - 候補：web.config / global.asa / データベース接続設定ファイル
- パフォーマンス要件は一般的なWeb操作の目安として記載、具体的なSLA定義は発見できず
  - 候補：要件定義書 / 非機能要件定義書 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 機能の主要ロジックはソースコードで確認済み
- **1（中リスク）**: トランザクション制御が明示されていないため、同時更新時のデータ整合性について要確認
- **0（低リスク）**: セキュリティ関連（CSRF、権限チェック）はコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] moveUp/moveDownの境界条件（ランク1、最大ランク）の動作確認
- [ ] 複数ユーザーが同時に並び替え操作した場合のデータ整合性確認
- [ ] イントラネットページと通常ページの分離が正しく動作することの確認
- [ ] パスワード継承ロジックが全サブページに適用されることの確認
- [ ] メニューキャッシュクリア後の再構築タイミングの確認
