---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：110-ゲストブック投稿

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/guestbook.asp` - cls_guestbookクラス定義（312行）
- E-02: `asp/includes/guestbookitem.asp` - cls_guestbookitemクラス定義（146行）
- E-03: `asp/process.asp` - ページアクションルーター（107-128行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.110定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ゲストブックはcls_guestbookクラスで実装 | E-01 | ○ |
| C-02 | アイテムはcls_guestbookitemクラスで実装 | E-02 | ○ |
| C-03 | process.aspの107-128行目で管理操作ルーティング | E-03 | ○ |
| C-04 | build()メソッドがHTML生成と投稿処理 | E-01 64-214行目 | ○ |
| C-05 | save()メソッドが投稿保存 | E-02 83-138行目 | ○ |
| C-06 | CAPTCHA検証実装 | E-01 173-175行目 | ○ |
| C-07 | HTMLリンク禁止チェック | E-01 176-178行目 | ○ |
| C-08 | IPブロック機能 | E-02 89-92行目 | ○ |
| C-09 | 一意キー生成（16文字） | E-02 95-96行目 | ○ |
| C-10 | tblGuestbookItem INSERT | E-02 98-107行目 | ○ |
| C-11 | 管理者通知メール送信 | E-02 109-122行目 | ○ |
| C-12 | approve()メソッド | E-02 140-146行目 | ○ |
| C-13 | remove()メソッド | E-02 128-138行目 | ○ |
| C-14 | bRequireValidation承認設定 | E-01 37行目, E-02 100行目 | ○ |
| C-15 | encrypt関数使用 | E-01 79行目 | ○ |
| C-16 | sanitize関数使用 | E-01 193, 200行目 | ○ |
| C-17 | セッションに投稿ID記録 | E-01 204行目 | ○ |
| C-18 | iPaging設定 | E-01 41行目 | ○ |
| C-19 | スマイリー機能 | E-01 233-238行目 | ○ |
| C-20 | sReply管理者返信 | E-01 201行目 | ○ |
| C-21 | dOnlineFrom/dOnlineUntil公開期間 | E-01 45-46行目 | ○ |
| C-22 | check()バリデーション | E-02 60-82行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし - 全ての主張がコードで確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての処理フローがコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] cls_guestbook.build()の処理フローが設計書と一致するか確認
- [ ] cls_guestbookitem.save()の保存処理確認
- [ ] CAPTCHA検証ロジック確認
- [ ] 承認・削除・編集の各アクション処理確認
- [ ] HTMLリンク禁止とIPブロックの実装確認
- [ ] 管理者通知メールの内容確認
