---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：111-フォーム送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **トランザクション仕様**：データベーストランザクション範囲の詳細確認が必要
  2. **パフォーマンス要件**：具体的な数値の根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/form.asp` - cls_formクラス定義
- E-02: `asp/process.asp` - フロントエンド処理分岐
- E-03: `asp/includes/functions.asp` - sanitize関数、CSRF対策関数
- E-04: `asp/includes/captcha.asp` - CAPTCHA画像生成
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォーム送信はお問い合わせフォーム等の送信処理を行う | E-05 (行112) | ○ |
| C-02 | 入力値のバリデーション（必須、メール形式、ファイルサイズ、ファイルタイプ）を行う | E-01 (296-373行目) | ○ |
| C-03 | CAPTCHA認証による不正送信防止 | E-01 (285-295行目), E-04 | ○ |
| C-04 | CSRF対策によるセキュリティ保護 | E-01 (274行目), E-03 (1619-1628行目) | ○ |
| C-05 | 送信データをtblFormSubmission、tblFormFieldValueに保存 | E-01 (377-425行目) | ○ |
| C-06 | 管理者への通知メール送信機能あり | E-01 (441-517行目) | ○ |
| C-07 | 自動応答メール送信機能あり | E-01 (518-547行目) | ○ |
| C-08 | カスタムスクリプト実行機能あり | E-01 (427-439行目) | ○ |
| C-09 | フィードバック表示またはリダイレクト | E-01 (555-559行目) | ○ |
| C-10 | ハニーポットによるスパム対策 | E-01 (270-273行目) | ○ |
| C-11 | FreeASPUploadによるファイルアップロード | E-01 (264-267行目) | ○ |
| C-12 | フィールドタイプ（テキスト、メール、URL、テキストエリア等）をサポート | E-01 (624-737行目) | ○ |
| C-13 | QS_secCodeHiddenによるCSRFトークン埋め込み | E-01 (580行目), E-03 (1613-1614行目) | ○ |
| C-14 | checkCSRF_Upload関数でCSRF検証 | E-01 (274行目), E-03 (1624-1628行目) | ○ |
| C-15 | sanitize関数によるXSS対策 | E-03 (1453-1455行目) | ○ |
| C-16 | ファイルサイズ検証はiMaxFileSize*1010で計算 | E-01 (322行目, 352行目) | ○ |
| C-17 | 許可ファイル拡張子チェック | E-01 (330-337行目) | ○ |
| C-18 | 画像ファイルはJPG/GIF/JPEG形式のみ許可 | E-01 (360-364行目) | ○ |
| C-19 | Cookie保存機能あり（bCookie設定時） | E-01 (297-301行目) | ○ |
| C-20 | フォーム定義はpick関数で取得 | E-01 (27-63行目) | ○ |
| C-21 | フィールド定義はfields関数で取得 | E-01 (233-249行目) | ○ |
| C-22 | 送信データIDを含む通知メール送信 | E-01 (454行目) | ○ |
| C-23 | ビジター情報を送信データと共に保存 | E-01 (510行目) | ○ |
| C-24 | トランザクションは個別に実行される | **根拠なし** | △ |
| C-25 | フォーム送信処理は3秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **トランザクション仕様の詳細**
  - コード上でトランザクション制御（BEGIN TRANSACTION/COMMIT/ROLLBACK）の明示的な記述が確認できなかった
  - 候補：データベース設定ファイル / ADO接続設定 / IIS設定

- **パフォーマンス要件の根拠**
  - 具体的な数値（3秒以内）の根拠となるドキュメントが確認できなかった
  - 候補：要件定義書 / 性能テスト結果 / SLA文書

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - フォーム表示・送信の基本機能（コード根拠十分）
- 0: 低リスク - セキュリティ対策（CSRF、CAPTCHA、サニタイズ）（コード根拠十分）
- 1: 中リスク - トランザクション整合性（明示的なトランザクション制御なし）
- 0: 低リスク - ファイルアップロード処理（コード根拠十分）

## 6) レビュアーチェックリスト（最小）

- [ ] トランザクション処理の実際の動作を確認（部分更新リスク評価）
- [ ] パフォーマンス要件の妥当性を確認
- [ ] ファイルアップロード時のエラーハンドリングが十分か確認
- [ ] 自動応答メールのフォーマット・内容が適切か確認
