---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：113-ページ印刷

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `printPage.asp` - 印刷ページメイン処理
- E-02: `asp/process.asp` - ページ情報取得処理
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 印刷用レイアウトでのページ表示機能 | E-01, E-03 (行114) | ○ |
| C-02 | printReplies=trueでテンプレートレンダリングをスキップ | E-01 (1行目), E-02 (278-280行目) | ○ |
| C-03 | XHTML 1.0 Transitional DOCTYPE | E-01 (1-2行目) | ○ |
| C-04 | ページタイトルを<title>タグに設定 | E-01 (4行目) "selectedPage.showTitle" | ○ |
| C-05 | Content-Type METAで文字コード設定 | E-01 (5行目) "QS_CHARSET" | ○ |
| C-06 | CSSリンク（qs_[tdir].css） | E-01 (6行目) | ○ |
| C-07 | sorttable.jsスクリプトのインクルード | E-01 (7行目) | ○ |
| C-08 | sApplicationチェックでアプリケーションページは終了 | E-01 (8行目) "Response.End" | ○ |
| C-09 | onloadでwindow.focus()とwindow.print()実行 | E-01 (10行目) | ○ |
| C-10 | タイトルを<b>タグで表示 | E-01 (11行目) | ○ |
| C-11 | <hr />で区切り線を表示 | E-01 (11行目) | ○ |
| C-12 | treatConstantsで定数展開 | E-01 (11行目) "treatConstants(...,true)" | ○ |
| C-13 | replaceBlocksでブロック置換 | E-01 (11行目) "selectedPage.replaceBlocks(pageTitle)" | ○ |
| C-14 | cleanUPASP()でクリーンアップ処理 | E-01 (14行目) | ○ |
| C-15 | 14行のコンパクトなファイル構成 | E-01 (ファイル全体) | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 印刷ページ表示処理（コード根拠十分）
- 0: 低リスク - 定数・ブロック置換処理（コード根拠十分）
- 0: 低リスク - 印刷ダイアログ起動（コード根拠十分）

## 6) レビュアーチェックリスト（最小）

- [ ] 印刷プレビューの見た目が適切か確認
- [ ] CSSが印刷用に最適化されているか確認
- [ ] window.print()が各ブラウザで正常動作するか確認
