---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：115-XMLサイトマップ出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `sitemap.asp` - XMLサイトマップ出力メイン処理
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 検索エンジン向けXMLサイトマップ生成 | E-01, E-02 (行116) | ○ |
| C-02 | sitemaps.org標準形式準拠 | E-01 (10-14行目) schemas/sitemap/0.9 | ○ |
| C-03 | XML宣言（version="1.0" encoding="UTF-8"） | E-01 (9行目) | ○ |
| C-04 | cls_searchで全ページ取得 | E-01 (17行目) "new cls_search" | ○ |
| C-05 | includeURL=false設定 | E-01 (18行目) | ○ |
| C-06 | allowEmptyString=true設定 | E-01 (19行目) | ○ |
| C-07 | includeListItems=true設定 | E-01 (20行目) | ○ |
| C-08 | フォーラム投稿URL生成 | E-01 (29-37行目) | ○ |
| C-09 | リストアイテムは親ID+アイテムID形式 | E-01 (44-45行目) | ○ |
| C-10 | ユーザーフレンドリーURL対応 | E-01 (47-48行目) | ○ |
| C-11 | 通常ページは暗号化ID形式 | E-01 (50-51行目) | ○ |
| C-12 | &はエスケープ（&amp;） | E-01 (35, 45行目) | ○ |
| C-13 | 60行程度のシンプルなファイル構成 | E-01 (ファイル全体) | ○ |
| C-14 | Response.Writeで出力 | E-01 (59行目) | ○ |
| C-15 | cleanUPASP()でクリーンアップ | E-01 (60行目) | ○ |
| C-16 | 検証サイトURLをコメントで記載 | E-01 (5-7行目) | ○ |
| C-17 | lastmod、changefreq、priority未実装 | E-01 (42-53行目) loc要素のみ | ○ |
| C-18 | 1000ページで10秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件の根拠**
  - 具体的な数値（1000ページで10秒以内）の根拠となるドキュメントが確認できなかった
  - 候補：要件定義書 / 性能テスト結果 / SLA文書

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - XMLサイトマップ生成処理（コード根拠十分）
- 0: 低リスク - URL形式処理（コード根拠十分）
- 1: 中リスク - 大規模サイトでのパフォーマンス（キャッシュ機構なし）

## 6) レビュアーチェックリスト（最小）

- [ ] sitemaps.org仕様への準拠を確認
- [ ] 大規模サイト（1000ページ以上）でのパフォーマンステスト
- [ ] lastmod等のオプション要素追加の必要性を検討
