---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：117-CSRF対策

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **メール送信機能の状態**：コード上でコメントアウトされている点の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/functions.asp` - CSRF関連関数定義（1607-1641行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSRFトークンベースの認証機能 | E-01 (1607-1641行目), E-02 (行118) | ○ |
| C-02 | secCode関数でトークン取得/生成 | E-01 (1607-1612行目) | ○ |
| C-03 | session("secCode")にトークン保存 | E-01 (1608-1611行目) | ○ |
| C-04 | GeneratePassWordでトークン生成 | E-01 (1609行目) | ○ |
| C-05 | QS_secCodeHiddenでhidden input生成 | E-01 (1613-1615行目) "<input type='hidden' name='QSSEC'" | ○ |
| C-06 | QS_secCodeURLでURLパラメータ生成 | E-01 (1616-1618行目) "QSSEC="&secCode | ○ |
| C-07 | checkCSRFでトークン検証 | E-01 (1619-1623行目) | ○ |
| C-08 | Request("QSSEC")とsecCode比較 | E-01 (1620行目) | ○ |
| C-09 | 不一致時にsendCSRFWarning呼び出し | E-01 (1621行目) | ○ |
| C-10 | checkCSRF_Uploadでアップロード用検証 | E-01 (1624-1628行目) | ○ |
| C-11 | sendCSRFWarningで管理者にメール通知 | E-01 (1629-1641行目) cls_mail_message使用 | ○ |
| C-12 | Application変数で重複メール防止 | E-01 (1630-1631行目) "CSRFMS" & UserIP | ○ |
| C-13 | theMail.sendがコメントアウト | E-01 (1637行目) "'theMail.send" | ○ |
| C-14 | Response.Endがコメントアウト | E-01 (1640行目) "'Response.End" | ○ |
| C-15 | トークンは英大文字と数字の8文字 | E-01 (800-829行目) GeneratePassWord関数 | ○ |
| C-16 | C_ADMINEMAILが設定されている場合のみメール送信 | E-01 (1630行目) | ○ |
| C-17 | getVisitorDetailsで訪問者情報取得 | E-01 (1636行目) | ○ |
| C-18 | 全管理画面で使用される | **使用箇所の網羅的確認が必要** | △ |

## 4) 不足情報（Unknown / Missing）

- **全管理画面での使用状況**
  - 主要な画面での使用は確認できたが、全画面での網羅的な使用確認は未実施
  - 候補：各画面のソースコードレビュー

## 5) リスクフラグ（レビュー観点）

- 1: 中リスク - メール送信がコメントアウト（CSRF攻撃検出時の通知が無効）
- 1: 中リスク - Response.Endがコメントアウト（CSRF検出後も処理が継続する可能性）
- 0: 低リスク - トークン生成・検証ロジック（コード根拠十分）

## 6) レビュアーチェックリスト（最小）

- [ ] sendCSRFWarningのコメントアウト部分を本番環境で有効化すべきか確認
- [ ] 全ての状態変更フォームでcheckCSRFが呼ばれているか確認
- [ ] トークンの予測困難性が十分か確認（Randomizeの使用方法）
- [ ] セッションタイムアウト時のユーザー体験を確認
