---
generated_at: 2026-01-23 11:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：118-CAPTCHA認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/captcha.asp` - CAPTCHA画像生成（全413行）
- E-02: `mailPage.asp` - CAPTCHA検証実装例（22-24行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スパムボット防止用の画像認証機能 | E-01, E-03 (行119) | ○ |
| C-02 | CreateGUID関数で4文字のコード生成 | E-01 (75-87行目, 406行目) | ○ |
| C-03 | 使用文字はA-Fと0-9 | E-01 (76行目) "ABCDEF1234567890" | ○ |
| C-04 | Session("CAPTCHA")にコード保存 | E-01 (407行目) | ○ |
| C-05 | BMP形式で画像出力 | E-01 (380行目) "image/bmp" | ○ |
| C-06 | 画像サイズ62x25ピクセル | E-01 (65行目) "Bitmap(25,62)" | ○ |
| C-07 | CodeLength=4（4文字固定） | E-01 (66行目) "const CodeLength = 4" | ○ |
| C-08 | 連続同一文字を回避 | E-01 (83行目) "loop while CStr(tmpChr) = CStr(Right(tmpGUID,1))" | ○ |
| C-09 | FontMapで文字パターン定義 | E-01 (22-40行目) | ○ |
| C-10 | ColorMapで配色パターン定義 | E-01 (44-57行目) 10種類 | ○ |
| C-11 | PrepareBitmapでビットマップ準備 | E-01 (170-227行目, 408行目) | ○ |
| C-12 | WriteCanvasで文字描画 | E-01 (111-168行目) | ○ |
| C-13 | SendBitmapで画像出力 | E-01 (362-401行目, 412行目) | ○ |
| C-14 | NoiseEffect 0-4の5種類 | E-01 (69行目) コメント参照 | ○ |
| C-15 | AddNoiseでノイズ効果追加 | E-01 (285-331行目, 409-411行目) | ○ |
| C-16 | キャッシュ無効化ヘッダー設定 | E-01 (382-384行目) "no-cache", "Pragma", "Expires = -1" | ○ |
| C-17 | 検証時はLCase比較 | E-02 (22行目) "LCase(session("CAPTCHA")) <> LCase(Left(Request.Form("CAPTCHA"),4))" | ○ |
| C-18 | 入力値の先頭4文字を比較 | E-02 (22行目) "Left(Request.Form("CAPTCHA"),4)" | ○ |
| C-19 | 不一致時はerr_captchaエラー | E-02 (24行目) "message.AddError("err_captcha")" | ○ |
| C-20 | Randomize(Timer)で乱数初期化 | E-01 (79行目, 90行目) | ○ |
| C-21 | Content-Disposition: inline設定 | E-01 (381行目) | ○ |
| C-22 | ASP Security Image Generator v3.0ベース | E-01 (3行目) コメント参照 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - CAPTCHA生成処理（コード根拠十分）
- 0: 低リスク - 検証処理（コード根拠十分）
- 1: 中リスク - CAPTCHAの強度（4文字、16種類の文字 = 65,536通り）

## 6) レビュアーチェックリスト（最小）

- [ ] 4文字16種類（65,536通り）のCAPTCHA強度が十分か確認
- [ ] OCR耐性（ノイズ効果の有効性）を確認
- [ ] セッションタイムアウト時のユーザー体験を確認
- [ ] 画像が正常に生成されているか確認
