---
generated_at: 2026-01-23 11:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：119-入力サニタイズ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **全画面での適用状況**：sanitize関数が全ての出力箇所で使用されているか確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/functions.asp` - サニタイズ関数定義（1065-1076行目、35-42行目、1453-1455行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XSS対策のための入力値エスケープ機能 | E-01, E-02 (行120) | ○ |
| C-02 | sanitize関数はquotRep関数のラッパー | E-01 (1453-1455行目) "sanitize=quotRep(sValue)" | ○ |
| C-03 | quotRep関数で"をエスケープ | E-01 (1069行目) 'replace(sValue,"""","&quot;",...)' | ○ |
| C-04 | quotRep関数で<をエスケープ | E-01 (1070行目) 'replace(quotRep,"<","&lt;",...)' | ○ |
| C-05 | quotRep関数で>をエスケープ | E-01 (1071行目) 'replace(quotRep,">","&gt;",...)' | ○ |
| C-06 | isLeegで空値チェック | E-01 (1066-1067行目) "if isLeeg(sValue) then quotRep=sValue" | ○ |
| C-07 | quotRepJS関数でシングルクォートエスケープ | E-01 (1074-1076行目) "replace(sValue,\"'\",\"\\'\",...)" | ○ |
| C-08 | removeCRB関数で<%を除去 | E-01 (39行目) 'replace(value,"<" & "%","",...)' | ○ |
| C-09 | removeCRB関数で%>を除去 | E-01 (40行目) 'replace(value,"%" & ">","",...)' | ○ |
| C-10 | replace第5引数-1で全置換 | E-01 (1069-1071行目) 引数確認 | ○ |
| C-11 | replace第6引数1で大文字小文字無視 | E-01 (1069-1071行目) 引数確認 | ○ |
| C-12 | &はエスケープ対象外 | E-01 (1069-1071行目) &の置換処理なし | ○ |
| C-13 | isLeeg関数でisNull、isEmpty、trim後空文字チェック | E-01 (86-93行目) | ○ |
| C-14 | メタタグ出力でsanitize使用 | docs/code-to-docs/画面設計書/196-メタタグ設定.md | ○ |
| C-15 | 検索結果表示でsanitize使用 | docs/code-to-docs/画面設計書/165-検索処理.md | ○ |
| C-16 | 全てのHTML出力箇所でsanitize使用 | **網羅的確認が必要** | △ |

## 4) 不足情報（Unknown / Missing）

- **全画面での適用状況**
  - 主要な画面での使用は確認できたが、全出力箇所での網羅的な使用確認は未実施
  - 候補：全ASPファイルのコードレビュー

## 5) リスクフラグ（レビュー観点）

- 1: 中リスク - &のエスケープ未実施（一部のコンテキストで問題となる可能性）
- 1: 中リスク - シングルクォートのHTML属性エスケープ未実施
- 0: 低リスク - 基本的なXSS対策（<、>、"のエスケープ）

## 6) レビュアーチェックリスト（最小）

- [ ] 全ての動的出力箇所でsanitize関数が使用されているか確認
- [ ] &のエスケープが必要な箇所を特定し、追加対策を検討
- [ ] シングルクォートを使用するHTML属性の有無を確認
- [ ] リッチテキスト出力箇所のサニタイズ戦略を確認
