---
generated_at: 2026-01-23 21:42:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：12-ページ複製機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：リストアイテム複製の所要時間は推測値

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_process.asp` - Copyアクション処理（65-73行目）
- E-02: `asp/includes/page.asp` - copy()メソッド定義（960-977行目）
- E-03: `asp/includes/menu.asp` - コピーアイコン表示（189-190行目）
- E-04: `asp/bs_listPage.asp` - リストアイテムのコピー機能（70-71行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（12行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Copyアクションで複製処理が開始される | E-01（65行目） | ○ |
| C-02 | bCopy=trueが設定される | E-01（67行目） | ○ |
| C-03 | copy()メソッドが呼び出される | E-01（68行目） | ○ |
| C-04 | iIdがnullに設定され新規レコード化される | E-02（964行目） | ○ |
| C-05 | bHomepageがfalseに設定される | E-02（965行目） | ○ |
| C-06 | sUserFriendlyURLが空文字に設定される | E-02（966行目） | ○ |
| C-07 | sCodeが空文字に設定される | E-02（967行目） | ○ |
| C-08 | タイトルに「(copy)」が付加される | E-02（968行目 "& " (copy)"） | ○ |
| C-09 | リストアイテムも再帰的に複製される | E-02（970-973行目） | ○ |
| C-10 | clearMenuCacheが呼び出される | E-02（975行目） | ○ |
| C-11 | secondAdmin.bPagesAdd権限でアクセス制御される | E-03（189行目） | ○ |
| C-12 | JavaScriptでconfirm確認ダイアログが表示される | E-03（190行目 "copyItem()") | ○ |
| C-13 | リストページ画面でもコピー機能が提供される | E-04（70-71行目） | ○ |
| C-14 | リストアイテム1件あたり約0.1秒の処理時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（リストアイテム複製時間）は実測データなし
  - 候補：パフォーマンステスト結果 / 実環境での計測データ

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 主要な複製ロジックはソースコードで確認済み
- **0（低リスク）**: セキュリティ関連（CSRF、権限チェック）はコードで確認済み
- **1（中リスク）**: 大量リストアイテム時のパフォーマンスについて実測確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 複製されたページのタイトルが正しく「(copy)」付きになること
- [ ] sUserFriendlyURLとsCodeが空になり重複エラーが発生しないこと
- [ ] リストページ複製時に全リストアイテムが複製されること
- [ ] リストアイテムのiListPageIDが新しいページIDに正しく設定されること
- [ ] 複製後のメニュー表示に新ページが反映されること
