---
generated_at: 2026-01-23 11:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：120-多言語対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **対応言語一覧**：tblLanguageに登録されている言語の完全な一覧の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/languageInit.asp` - l()関数、initLanguage2関数定義（全69行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング
- E-04: `docs/code-to-docs/データベース設計書/データベース設計書.md` - tblLanguage定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理画面・フロントエンドの多言語切り替え | E-01, E-02 (行121) | ○ |
| C-02 | l()関数でラベル値取得 | E-01 (36-47行目) | ○ |
| C-03 | getCurrentLanguage()で現在の言語取得 | E-01 (59-69行目) | ○ |
| C-04 | 言語優先順位: session > customer.language > デフォルト(1) | E-01 (61-67行目) | ○ |
| C-05 | Application変数でキャッシュ | E-01 (41-44行目, 28行目) QS_CMS_lb_ | ○ |
| C-06 | initLanguage2()でDB読み込み | E-01 (4-34行目) | ○ |
| C-07 | tblLabel、tblLabelValueのJOINクエリ | E-01 (10-11行目) | ○ |
| C-08 | Dictionaryオブジェクトでラベル管理 | E-01 (8行目) "scripting.dictionary" | ○ |
| C-09 | ラベルコードは小文字で使用 | E-01 (42行目) "lcase(code)" | ○ |
| C-10 | rebrand()でブランド名置換 | E-01 (49-57行目) | ○ |
| C-11 | QuickerSiteをカスタム名に置換 | E-01 (54行目) "replace(...\"QuickerSite\",MYQS_name,...)" | ○ |
| C-12 | デフォルト言語ID=1 | E-01 (66行目) "getCurrentLanguage=1" | ○ |
| C-13 | session("QS_LANG")で言語設定 | E-01 (61-62行目) | ○ |
| C-14 | customer.languageでサイト設定言語 | E-01 (63-64行目) | ○ |
| C-15 | db.getDynamicRSLabelsでDB接続 | E-01 (12行目) | ○ |
| C-16 | getRows()で一括取得 | E-01 (15行目) | ○ |
| C-17 | show()関数でラベル値処理 | E-01 (21行目) | ○ |
| C-18 | 対応言語の完全な一覧 | **tblLanguageの実データ確認が必要** | △ |

## 4) 不足情報（Unknown / Missing）

- **対応言語一覧**
  - tblLanguageに登録されている言語の実データを確認できていない
  - 候補：データベースの直接参照、または管理画面の言語設定確認

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - l()関数の実装（コード根拠十分）
- 0: 低リスク - キャッシュ機構（コード根拠十分）
- 1: 中リスク - キャッシュ更新タイミング（ラベル編集時の即時反映）

## 6) レビュアーチェックリスト（最小）

- [ ] tblLanguageに登録されている言語一覧を確認
- [ ] ラベル編集後のキャッシュ更新処理を確認
- [ ] 未定義ラベル参照時の挙動を確認
- [ ] 言語切り替え時のユーザー体験を確認
