---
generated_at: 2026-01-23 21:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-リストページ管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：100件という推奨値の根拠

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_listPage.asp` - リストページ管理画面（1-82行目）
- E-02: `asp/bs_editListItem.asp` - リストアイテム編集画面（1-36行目）
- E-03: `asp/bs_processPage.asp` - ページ保存処理（11-25行目）
- E-04: `asp/includes/page.asp` - cls_pageクラス、sOrderBY/iListPageIDプロパティ
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（13行目）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sOrderBYに値があるページはリストページとして識別される | E-04, E-01（79行目 makenormalpage） | ○ |
| C-02 | iListPageIDで親リストページに関連付けられる | E-02（9行目） | ○ |
| C-03 | リストアイテム削除時はbDeleted=true、bOnline=falseに設定 | E-01（13-15行目） | ○ |
| C-04 | コピー時にsCode、sUserFriendlyURLが空になる | E-01（29-30行目） | ○ |
| C-05 | コピー時にタイトルに「(copy)」が付加される | E-01（31行目） | ○ |
| C-06 | save_listitemアクションで親リストページ画面へリダイレクト | E-03（22-23行目） | ○ |
| C-07 | 画像添付機能はcustomer.bListItemPic設定で制御 | E-01（56行目） | ○ |
| C-08 | 画像は listitemimages/ ディレクトリに保存 | E-01（58行目） | ○ |
| C-09 | 外部URL設定時にsLPExternalURLを使用 | E-02（18行目） | ○ |
| C-10 | 新しいウィンドウで開くフラグはbLPExternalOINW | E-02（19行目） | ○ |
| C-11 | 日付設定にdPage、dOnlineFrom、dOnlineUntillを使用 | E-02（14-16行目） | ○ |
| C-12 | ユーザーフレンドリーURL設定が可能 | E-02（25行目） | ○ |
| C-13 | WYSIWYGエディタ（CKEditor）で本文編集 | E-02（23行目 createFCKInstance） | ○ |
| C-14 | 通常ページ変換機能が存在（makenormalpage） | E-01（79行目） | ○ |
| C-15 | checkCSRF()によるトークン検証 | E-01（9,23行目） | ○ |
| C-16 | 推奨リストアイテム数100件以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（推奨アイテム数100件）は実測データなし
  - 候補：パフォーマンステスト結果 / 運用ガイドライン

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 主要なCRUD操作ロジックはソースコードで確認済み
- **0（低リスク）**: セキュリティ関連（CSRF）はコードで確認済み
- **1（中リスク）**: 大量リストアイテム時のパフォーマンスについて実測確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] リストページ作成時にsOrderBYが正しく設定されること
- [ ] リストアイテム作成時にiListPageIDが正しく設定されること
- [ ] 削除がbDeleted=trueの論理削除として動作すること
- [ ] コピー機能でsCodeとsUserFriendlyURLがリセットされること
- [ ] 画像添付機能がcustomer.bListItemPic設定で制御されること
- [ ] 外部URLとコンテンツの排他制御が動作すること
