---
generated_at: 2026-01-23 21:48:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-外部URL設定機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_editExternalURL.asp` - 外部URL編集画面（1-6行目）
- E-02: `asp/bs_convertToExternalURL.asp` - 外部URL変換リンク（1-3行目）
- E-03: `asp/includes/page.asp` - getClickLinkプロパティ（925-934行目）
- E-04: `asp/includes/page.asp` - Check関数（413-418行目、URL検証）
- E-05: `asp/includes/page.asp` - Save関数（458-462行目、プレフィックス除去）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（14行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sExternalURLに値があるページは外部URLページとして識別 | E-03（925行目 if not isLeeg） | ○ |
| C-02 | URLプレフィックス選択にcls_urlTypeListを使用 | E-01（5行目 cls_urlTypeList） | ○ |
| C-03 | bOpenInNewWindow=trueでtarget="_blank"が付与 | E-03（926-927行目） | ○ |
| C-04 | sRel属性がリンクに追加される | E-03（929-931行目） | ○ |
| C-05 | sClassname属性がリンクに追加される | E-03（932-934行目） | ○ |
| C-06 | URLプレフィックスが保存時に除去される | E-05（459-462行目） | ○ |
| C-07 | sExternalURLPrefixとsExternalURLを連結してURLを構成 | E-03（928行目） | ○ |
| C-08 | secondAdmin.bPageBody権限でアクセス制御 | E-01（5行目 if条件）, E-02（2行目） | ○ |
| C-09 | sExternalURLPrefixが設定時はsExternalURLが必須 | E-04（413-418行目） | ○ |
| C-10 | ホームページは外部URLに変換できない | E-02（2行目 not page.bHomepage） | ○ |
| C-11 | QSCCB_530_300クラスでColorbox表示 | E-01（5行目 Tipコメント） | ○ |
| C-12 | 通常ページへの変換機能が存在 | E-01（5行目 includes） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主要機能がソースコードで確認済み
- **0（低リスク）**: セキュリティ関連（権限チェック）がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] URLプレフィックス選択リストが正しく表示されること
- [ ] 外部URL保存時にプレフィックスが自動除去されること
- [ ] bOpenInNewWindowがtarget="_blank"に正しく反映されること
- [ ] sRel、sClassname属性がリンクに正しく追加されること
- [ ] 通常ページから外部URLページへの変換が動作すること
