---
generated_at: 2026-01-23 21:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-ページパスワード保護機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_applyPW.asp` - パスワード設定画面（1-5行目）
- E-02: `asp/bs_processPage.asp` - パスワード保存・削除処理（45-82行目）
- E-03: `asp/includes/page.asp` - resetAllSubPasswords関数（978-992行目）
- E-04: `asp/includes/page.asp` - removeAllSubPasswords関数（993行目以降）
- E-05: `asp/includes/menu.asp` - パスワード保護アイコン表示（192-197行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（15行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bPagesPW権限でアクセス制御 | E-01（4行目 logon.hasaccess） | ○ |
| C-02 | パスワードは3文字以上15文字以下 | E-02（48行目 len < 3チェック） | ○ |
| C-03 | パスワードは保存時に小文字に変換される | E-02（51行目 lcase()） | ○ |
| C-04 | resetAllSubPasswordsでサブページに一括適用 | E-02（53行目）, E-03 | ○ |
| C-05 | removeAllSubPasswordsでサブページのPW一括削除 | E-02（75行目）, E-04 | ○ |
| C-06 | sTotalPWが設定時は個別設定不可の表示 | E-01（4行目 if isleeg(customer.sTotalPW)） | ○ |
| C-07 | 親ページにPWがある場合は削除ボタン非表示 | E-01（4行目 if isLeeg(page.parentPage.sPw)） | ○ |
| C-08 | delete_pwでsPwを空に設定 | E-02（63行目） | ○ |
| C-09 | delete_pw_allでsPwを空に設定し全サブも削除 | E-02（73-75行目） | ○ |
| C-10 | checkCSRF()によるトークン検証 | E-02（46, 62, 72行目） | ○ |
| C-11 | メニューでロック/アンロックアイコン表示 | E-05（193-197行目） | ○ |
| C-12 | ページ移動時に親のパスワードを継承 | E-03（bs_process.asp 55-58行目参照） | ○ |
| C-13 | 保存後にメニューキャッシュクリア | E-03（991行目 clearMenuCache） | ○ |
| C-14 | リダイレクト先はbIntranetフラグで決定 | E-02（54-58, 66-70行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 主要な機能ロジックがソースコードで確認済み
- **2（高リスク）**: パスワードが平文保存される点はセキュリティ上の注意が必要
- **0（低リスク）**: CSRF対策、権限チェックはコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] パスワード長が3文字未満の場合にエラーになること
- [ ] パスワードが小文字に変換されて保存されること
- [ ] サブページへの一括適用が正しく動作すること
- [ ] サブページのパスワード一括削除が正しく動作すること
- [ ] sTotalPW設定時に個別設定が無効になること
- [ ] 親ページにパスワードがある場合に削除ボタンが非表示になること
- [ ] 【重要】パスワードが平文保存されることのセキュリティリスクを確認
