---
generated_at: 2026-01-23 21:52:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-ユーザーフレンドリーURL設定機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/includes/page.asp` - forceUFL関数（84-114行目）
- E-02: `asp/includes/page.asp` - Check関数URL検証（384-412行目）
- E-03: `asp/includes/page.asp` - pickByUserFriendlyURL関数（115-237行目）
- E-04: `asp/bs_url.asp` - URL入力フィールド（1-4行目）
- E-05: `asp/includes/page.asp` - getSimpleLink/getClickLink（905-938行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（16行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IsAlphaNumericで文字種チェック | E-02（401-411行目） | ○ |
| C-02 | 最大50文字制限 | E-01（106行目 left 50） | ○ |
| C-03 | 同一顧客ID内で重複禁止 | E-02（402-407行目 SELECT WHERE） | ○ |
| C-04 | 新規ページ作成時にタイトルからURL自動生成 | E-01（86-106行目） | ○ |
| C-05 | スペースをハイフンに変換 | E-01（89行目 replace " " "-") | ○ |
| C-06 | 特殊文字（?!'）を除去 | E-01（90-92行目） | ○ |
| C-07 | 連続ハイフンを単一に | E-01（94-100行目 7回繰り返し） | ○ |
| C-08 | 小文字に変換 | E-01（106行目 lcase） | ○ |
| C-09 | コピー時はsUserFriendlyURLが空 | E-01（86行目 not bCopy条件） | ○ |
| C-10 | customer.bUserFriendlyURLとbPageUFL両方で制御 | E-04（2行目 if条件） | ○ |
| C-11 | QS_UFL_プレフィックスでキャッシュ | E-03（125, 218行目） | ○ |
| C-12 | 存在しないURLで404またはホームページリダイレクト | E-03（222-229行目） | ○ |
| C-13 | 先頭末尾のスラッシュを除去 | E-02（395-400行目） | ○ |
| C-14 | getClickLinkでsUserFriendlyURLを使用 | E-05（935-936行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主要機能がソースコードで確認済み
- **0（低リスク）**: 入力検証（IsAlphaNumeric）が実装されている
- **0（低リスク）**: 重複チェックが実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] タイトルからURL自動生成が正しく動作すること
- [ ] 特殊文字が除去・置換されること
- [ ] 連続ハイフンが単一に正規化されること
- [ ] URLが小文字で保存されること
- [ ] 重複URLでエラーになること
- [ ] 英数字以外でエラーになること
- [ ] フロントエンドでのURL解決が動作すること
- [ ] キャッシュが正しく機能すること
