---
generated_at: 2026-01-23 21:55:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-ページプレビュー機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_preview.asp` - プレビューリンク生成（1-18行目）
- E-02: `asp/bs_listPage.asp` - リストアイテムプレビュー（49-53行目）
- E-03: `asp/bs_editItem.asp` - プレビューリンク配置（13行目 include）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（17行目）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページIDが0の場合はプレビュー不可 | E-01（3行目 if convertGetal(page.iID)<>0） | ○ |
| C-02 | 新しいウィンドウ（target="_blank"）で開く | E-01（8,14行目 _blank） | ○ |
| C-03 | リストアイテムはアンカーリンク付き | E-01（8行目 #encrypt(page.iId)） | ○ |
| C-04 | ユーザーフレンドリーURL優先 | E-02（49-52行目 if not customer.bUserFriendlyURL） | ○ |
| C-05 | メディアボタンリンク生成 | E-01（5行目 bs_itemmedia.asp） | ○ |
| C-06 | ページIDはencrypt関数で暗号化 | E-01（8,14行目 encrypt） | ○ |
| C-07 | リストページIDとアイテムIDの両方を渡す | E-01（8行目 iID, item パラメータ） | ○ |
| C-08 | getArtLink関数でリンク生成 | E-01（8,14行目 getArtLink） | ○ |
| C-09 | secondAdmin.bSetupPageElementsでメディアボタン制御 | E-01（11行目 if secondAdmin.bSetupPageElements） | ○ |
| C-10 | プレビューボタンはページ編集画面に配置 | E-03（13行目 include bs_preview.asp） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主要機能がソースコードで確認済み
- **1（中リスク）**: プレビューURLの共有によるセキュリティ影響を確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 新規ページ（未保存）ではプレビューボタンが非表示になること
- [ ] 通常ページとリストアイテムでURL形式が異なること
- [ ] 新しいウィンドウでプレビューが開くこと
- [ ] リストアイテムプレビュー時にアンカーリンクでスクロールすること
- [ ] ユーザーフレンドリーURL設定時にそのURLでプレビューされること
