---
generated_at: 2026-01-23 21:58:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-コンテナページ管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_editContainer.asp` - コンテナ編集画面（1-5行目）
- E-02: `asp/bs_convertToContainerItem.asp` - コンテナ変換リンク（1-3行目）
- E-03: `asp/includes/page.asp` - getLinkプロパティ（891-903行目）
- E-04: `asp/includes/page.asp` - Save関数（434-437行目、ホームページ時の処理）
- E-05: `asp/includes/menu.asp` - コンテナアイコン表示（173-175行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（18行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bContainerPage=trueでコンテナ識別 | E-01（hidden input）, E-03（892行目） | ○ |
| C-02 | bContainerPageがhidden inputで送信 | E-01（4行目 hidden bContainerPage） | ○ |
| C-03 | パスワード未設定時はクリック不可 | E-03（892-893行目 cursor: default） | ○ |
| C-04 | onclick="javascript:return false;"でリンク無効化 | E-03（893行目） | ○ |
| C-05 | subcontainerクラスが追加される | E-03（899-901行目） | ○ |
| C-06 | ホームページ設定時はbContainerPage=false | E-04（436行目） | ○ |
| C-07 | コンテナアイコンがメニューに表示される | E-05（173-175行目） | ○ |
| C-08 | secondAdmin.bPageBody権限で変換制御 | E-02（2行目） | ○ |
| C-09 | ホームページは変換不可 | E-02（2行目 not page.bHomepage） | ○ |
| C-10 | bs_commoncont.aspで共通フィールド表示 | E-01（4行目 include） | ○ |
| C-11 | bs_sortorder.aspで並び順設定 | E-01（4行目 include） | ○ |
| C-12 | 変換リンク（ItemWithContent, ExternalURL）配置 | E-01（4行目 include） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主要機能がソースコードで確認済み
- **0（低リスク）**: 権限チェックが実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] bContainerPage=trueで保存されること
- [ ] パスワード未設定のコンテナはクリック不可になること
- [ ] ホームページ設定時にbContainerPageがfalseになること
- [ ] コンテナアイコンがメニューに表示されること
- [ ] コンテンツ付きページへの変換が動作すること
- [ ] 外部URLページへの変換が動作すること
