---
generated_at: 2026-01-23 22:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-ページブロック編集機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_editPageBlocks.asp` - ページブロック編集画面（1-19行目）
- E-02: `asp/includes/page.asp` - sProp01〜sProp08プロパティ定義（11行目）
- E-03: `asp/includes/page.asp` - save関数でのsProp保存（556-563行目）
- E-04: `asp/includes/page.asp` - replaceBlocks関数（1607-1654行目）
- E-05: `asp/includes/customer.asp` - デフォルト値sProp01〜sProp08（15行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（19行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bSetupPageElements権限でアクセス制御 | E-01（4行目 logon.hasaccess secondAdmin.bSetupPageElements） | ○ |
| C-02 | 8つのブロック（sProp01〜08）を編集可能 | E-01（9-16行目）, E-02 | ○ |
| C-03 | removeEmptyPで空段落除去 | E-01（9-16行目 removeEmptyP(convertStr(Request.Form))） | ○ |
| C-04 | checkCSRFでトークン検証 | E-01（8行目） | ○ |
| C-05 | page.saveで保存 | E-01（17行目 if page.save then message.Add） | ○ |
| C-06 | sProp01〜08がtblPageに保存される | E-03（556-563行目 rs("sProp01")〜rs("sProp08")） | ○ |
| C-07 | 奇数ブロックはtextarea | E-01（18行目 textarea for sProp01,03,05,07） | ○ |
| C-08 | 偶数ブロックはWYSIWYGエディタ | E-01（18行目 createFCKInstance for sProp02,04,06,08） | ○ |
| C-09 | customerのデフォルト値が参考表示される | E-01（18行目 customer.sPropXX） | ○ |
| C-10 | replaceBlocks関数でプレースホルダ置換 | E-04（1607-1654行目） | ○ |
| C-11 | ページ固有値優先、なければcustomer値使用 | E-04（1610-1614行目 if not isLeeg(sProp01) then...elseif） | ○ |
| C-12 | 未使用プレースホルダは空文字置換 | E-04（1651-1653行目 for iB=1 to 8） | ○ |
| C-13 | [PAGE_BLOCK0プレフィックスで存在チェック | E-04（1609行目 if instr(replaceBlocks,"[PAGE_BLOCK0")=0） | ○ |
| C-14 | customerにデフォルト値sProp01〜08あり | E-05（15行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主要機能がソースコードで確認済み
- **0（低リスク）**: 権限チェックが実装されている
- **0（低リスク）**: CSRF対策が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] bSetupPageElements権限でアクセス制御が機能すること
- [ ] 8つのブロックが正しく保存されること
- [ ] 奇数ブロックがtextarea、偶数ブロックがWYSIWYGで編集できること
- [ ] ページ固有値がcustomerデフォルト値より優先されること
- [ ] テンプレート内で[PAGE_BLOCK01]〜[PAGE_BLOCK08]が正しく置換されること
- [ ] 未設定ブロックが空文字に置換されること
