---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-管理者ログアウト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_logoff.asp` - ログオフ画面メインファイル（11行）
- E-02: `asp/includes/LogonEdit.asp` - cls_LogonEditクラス（241行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | logon.logoffBO()でバックオフィスログオフ | E-01（5行目）、E-02（183-188行目） | ○ |
| C-02 | Session.Abandon()でセッション破棄 | E-02（187行目） | ○ |
| C-03 | 認証Cookieを空文字列にクリア | E-01（6行目） | ○ |
| C-04 | SecondAdmin認証フラグをfalseに設定 | E-01（7行目） | ○ |
| C-05 | メイン認証フラグをfalseに設定 | E-01（8行目） | ○ |
| C-06 | ログイン画面へリダイレクト | E-01（9行目） | ○ |
| C-07 | FCK許可IPキャッシュをクリア | E-02（184行目） | ○ |
| C-08 | BOメニューキャッシュをクリア | E-02（185-186行目） | ○ |
| C-09 | loggedoffパラメータで完了画面表示 | E-01（4行目: if文の条件） | ○ |
| C-10 | bs_security.aspで認証チェック | E-01（4行目: インクルード） | ○ |
| C-11 | 関連画面No.3,4 | E-04 | ○ |
| C-12 | 機能カテゴリは「管理画面/認証」 | E-03 | ○ |
| C-13 | 主要ファイルはbs_logoff.asp | E-03 | ○ |
| C-14 | Cookie名はcId&"hfsdsiiqqssdfjf" | E-01（6行目） | ○ |
| C-15 | ログオフ完了メッセージと再ログインリンク表示 | E-01（10行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなログオフ処理で、全てソースコードで確認済み
- 0: 低リスク - データベース操作なし

## 6) レビュアーチェックリスト（最小）
- [ ] Session.Abandon()がセッション情報を完全に破棄しているか確認
- [ ] Cookieクリア後に認証情報が残存しないか確認
- [ ] キャッシュクリアが確実に行われているか確認
