---
generated_at: 2026-01-23 22:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-バナーメニュー編集機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_editBannerMenu.asp` - バナーメニュー編集画面（1-15行目）
- E-02: `asp/includes/customer.asp` - プロパティ定義（4, 12, 14行目）
- E-03: `asp/includes/customer.asp` - pick関数でのデータ読み込み（106, 144-145, 163-164行目）
- E-04: `asp/includes/customer.asp` - save関数でのデータ保存（353, 381, 389-390, 409-410行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義（20行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bSetupPageElements権限でアクセス制御 | E-01（4行目 logon.hasaccess secondAdmin.bSetupPageElements） | ○ |
| C-02 | checkCSRFでトークン検証 | E-01（5行目） | ○ |
| C-03 | sLeftBanner, sBannerMenu, sRightBannerを編集可能 | E-01（6-8行目）, E-02（4, 12行目） | ○ |
| C-04 | sHighlights, sContactInfoを編集可能 | E-01（9-10行目）, E-02（14行目） | ○ |
| C-05 | removeEmptyPでバナーコンテンツの空段落除去 | E-01（6-8行目 removeEmptyP(convertStr(Request.Form))） | ○ |
| C-06 | sHighlights, sContactInfoはconvertStrのみ | E-01（9-10行目 convertStr without removeEmptyP） | ○ |
| C-07 | bannerApplicationはbApplicationpath権限要 | E-01（11行目 if secondAdmin.bApplicationpath） | ○ |
| C-08 | customer.saveで保存 | E-01（12行目 if customer.save then message.Add） | ○ |
| C-09 | defaultTemplate=0で3カラムレイアウト | E-01（13行目 if convertGetal(customer.defaultTemplate)=0） | ○ |
| C-10 | defaultTemplate≠0で2カラムレイアウト | E-01（14行目 else） | ○ |
| C-11 | バナーはWYSIWYGエディタで編集 | E-01（13-14行目 createFCKInstance） | ○ |
| C-12 | sHighlights/sContactInfoは最大50文字 | E-01（14行目 maxlength="50"） | ○ |
| C-13 | bannerApplicationは最大255文字 | E-01（13行目 maxlength=255） | ○ |
| C-14 | tblCustomerにバナーデータ保存 | E-04（353, 381, 389-390, 409-410行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主要機能がソースコードで確認済み
- **0（低リスク）**: 権限チェックが実装されている
- **0（低リスク）**: CSRF対策が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] bSetupPageElements権限でアクセス制御が機能すること
- [ ] 3つのバナー（左、メニュー下、右）が正しく保存されること
- [ ] ハイライトと連絡先情報が正しく保存されること
- [ ] defaultTemplate=0で3カラムレイアウトが表示されること
- [ ] defaultTemplate≠0で2カラムレイアウトが表示されること
- [ ] bannerApplicationがbApplicationpath権限で制御されること
- [ ] WYSIWYGエディタでバナーコンテンツが編集できること
