---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-デフォルトブロック編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **customer.saveのトランザクション仕様**：実装詳細の確認が必要
  2. **データベーステーブル名**：実際のテーブル構造の確認推奨
  3. **FCKEditorの利用**：エディタ実装の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editProps.asp` - メイン処理ファイル
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `asp/bs_security.asp` - セキュリティ処理（インクルード参照）
- E-05: `asp/begin.asp` - 初期化処理（インクルード参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 8つのデフォルトブロック（sProp01〜sProp08）を管理する | E-01（6-13行目） | ○ |
| C-02 | secondAdmin.bSetupPageElements権限によるアクセス制御 | E-01（4行目） | ○ |
| C-03 | CSRFトークン検証を実施 | E-01（5行目、checkCSRF()呼び出し） | ○ |
| C-04 | removeEmptyPによる空タグ削除 | E-01（6-13行目） | ○ |
| C-05 | convertStrによる文字列サニタイズ | E-01（6-13行目） | ○ |
| C-06 | customer.saveによるデータ保存 | E-01（14行目） | ○ |
| C-07 | 成功時にmessage.Add("fb_saveOK")を呼び出す | E-01（14行目） | ○ |
| C-08 | FCKEditorを使用したリッチテキスト編集 | E-01（createFCKInstance呼び出し） | ○ |
| C-09 | 奇数ブロックはテキストエリア、偶数ブロックはFCKEditor | E-01（フォーム構造） | ○ |
| C-10 | QS_secCodeHiddenによるCSRFトークン埋め込み | E-01（15行目） | ○ |
| C-11 | quotrepによる出力時エスケープ | E-01（15行目） | ○ |
| C-12 | 機能名「デフォルトブロック編集」 | E-02（21行目） | ○ |
| C-13 | bs_editProps.aspが関連ファイル | E-02（21行目） | ○ |
| C-14 | 画面No.193「プロパティ編集」が関連画面 | E-03（234行目） | ○ |
| C-15 | begin.aspのインクルード | E-01（1行目） | ○ |
| C-16 | bs_header.aspによるナビゲーション表示 | E-01（4行目） | ○ |
| C-17 | POSTメソッドによるフォーム送信 | E-01（method="post"） | ○ |
| C-18 | customer.saveのトランザクション管理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- トランザクション管理の実装詳細（customer.saveメソッドの内部実装）
  - 候補：customerクラスの定義ファイル / データベースアクセス層の実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する主張は全てソースコードで確認済み
- 1: 中リスク - トランザクション仕様についてはcustomerクラスの実装確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] bs_editProps.aspのソースコードが設計書の記載と一致することを確認
- [ ] 8つのブロック（sProp01〜sProp08）が全て記載通りに処理されていることを確認
- [ ] FCKEditorの偶数ブロックへの適用が正しいことを確認
- [ ] CSRFトークン検証が確実に実施されていることを確認
- [ ] customerクラスのsaveメソッドのトランザクション処理を確認（推奨）
