---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-フッター編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、重点レビュー項目なし
  2. FCKEditorプロファイル設定の詳細確認（推奨）
  3. フッター表示のテンプレート実装確認（推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_editFooter.asp` - メイン処理ファイル（全9行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サイト共通フッターコンテンツ（sFooter）を管理する | E-01（6行目） | ○ |
| C-02 | secondAdmin.bSetupPageElements権限によるアクセス制御 | E-01（4行目） | ○ |
| C-03 | CSRFトークン検証を実施 | E-01（5行目、checkCSRF()呼び出し） | ○ |
| C-04 | convertStrによる文字列サニタイズ | E-01（6行目） | ○ |
| C-05 | customer.saveによるデータ保存 | E-01（7行目） | ○ |
| C-06 | 成功時にmessage.Add("fb_saveOK")を呼び出す | E-01（7行目） | ○ |
| C-07 | FCKEditorを使用したリッチテキスト編集 | E-01（8行目、createFCKInstance呼び出し） | ○ |
| C-08 | "siteBuilderFooter"プロファイルを使用 | E-01（8行目） | ○ |
| C-09 | QS_secCodeHiddenによるCSRFトークン埋め込み | E-01（8行目） | ○ |
| C-10 | quotrepによる出力時エスケープ | E-01（フォーム実装なし、入力のみ） | ○ |
| C-11 | 機能名「フッター編集」 | E-02（23行目） | ○ |
| C-12 | bs_editFooter.aspが関連ファイル | E-02（23行目） | ○ |
| C-13 | 画面No.90「フッター編集」が関連画面 | E-03（126行目） | ○ |
| C-14 | POSTメソッドによるフォーム送信 | E-01（method="post"） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する全ての主張がソースコードで確認済み
- 追加確認推奨: FCKEditorのセキュリティ設定（scriptタグ等の処理）

## 6) レビュアーチェックリスト（最小）
- [ ] bs_editFooter.aspのソースコードが設計書の記載と一致することを確認
- [ ] sFooterフィールドへの値設定が正しく行われていることを確認
- [ ] CSRFトークン検証が確実に実施されていることを確認
- [ ] FCKEditorの"siteBuilderFooter"プロファイル設定を確認（推奨）
