---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-ピール広告

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、重点レビュー項目なし
  2. フロントエンド表示処理の確認（推奨）
  3. generatePassword()関数の実装確認（推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_peel.asp` - ピール設定画面（全30行）
- E-02: `asp/bs_selectPeel.asp` - 画像選択画面（全6行）
- E-03: `asp/bs_peelUpload.asp` - アップロード処理（全44行）
- E-04: `asp/bs_process.asp` - savepeel処理（185-213行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bSetupPageElements権限によるアクセス制御 | E-01（4行目） | ○ |
| C-02 | CSRFトークン検証（保存時） | E-04（186行目） | ○ |
| C-03 | CSRFトークン検証（アップロード時） | E-03（9行目） | ○ |
| C-04 | URL必須チェック | E-04（204行目） | ○ |
| C-05 | フリップカラー必須チェック | E-04（204行目） | ○ |
| C-06 | URLデフォルト値"http://" | E-01（5-6行目） | ○ |
| C-07 | アイドル時サイズデフォルト70px | E-01（8-9行目） | ○ |
| C-08 | アクティブ時サイズデフォルト300px | E-01（10-12行目） | ○ |
| C-09 | 16色のフリップカラー選択 | E-01（14-23行目、ループ0-15） | ○ |
| C-10 | URL最大255文字 | E-04（198行目、left関数） | ○ |
| C-11 | PNG/JPG/GIF形式のみ許可 | E-03（14-18行目） | ○ |
| C-12 | ファイルサイズ上限2MB | E-03（22行目、2000000バイト） | ○ |
| C-13 | ランダムファイル名で保存 | E-03（30行目、generatePassword） | ○ |
| C-14 | customer.sPeelImage設定 | E-03（32行目） | ○ |
| C-15 | 削除時の全設定クリア | E-04（188-196行目） | ○ |
| C-16 | bPeelOINW設定 | E-04（200行目） | ○ |
| C-17 | sPeelFlipColor設定 | E-04（201行目） | ○ |
| C-18 | sPeelIdleSize設定 | E-04（202行目） | ○ |
| C-19 | sPeelMOSize設定 | E-04（203行目） | ○ |
| C-20 | bPeelEnabled設定 | E-04（199行目） | ○ |
| C-21 | 画像未設定時は画像アップロード画面へ遷移 | E-04（207-208行目） | ○ |
| C-22 | 機能名「ピール広告」 | E-05（25行目） | ○ |
| C-23 | bs_peel.asp、bs_peelUpload.aspが関連ファイル | E-05（25行目） | ○ |
| C-24 | 画面No.81-83が関連画面 | E-06（116-118行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する全ての主張がソースコードで確認済み
- 追加確認推奨: フロントエンドでのピール表示JavaScript実装

## 6) レビュアーチェックリスト（最小）
- [ ] bs_peel.aspのソースコードが設計書の記載と一致することを確認
- [ ] bs_process.aspのsavepeel処理を確認
- [ ] bs_peelUpload.aspのバリデーション処理を確認
- [ ] フリップカラー画像（pageflip0-15.png）の存在を確認
- [ ] ファイルサイズ上限（2MB）が正しく適用されることを確認
- [ ] generatePassword()関数のランダム性を確認（推奨）
