---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-テンプレート一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、重点レビュー項目なし
  2. cls_templateクラスの詳細実装確認（推奨）
  3. ローカルテンプレートライブラリの設定確認（推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_templateList.asp` - メイン処理ファイル（全127行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bTemplates権限によるアクセス制御 | E-01（4行目） | ○ |
| C-02 | CSRFトークン検証 | E-01（7行目、checkCSRF） | ○ |
| C-03 | copyアクション処理 | E-01（9-10行目） | ○ |
| C-04 | deleteアクション処理 | E-01（11-12行目） | ○ |
| C-05 | defaultアクション処理 | E-01（13-15行目） | ○ |
| C-06 | customer.templatesでコレクション取得 | E-01（19-20行目） | ○ |
| C-07 | テンプレート1つの場合は削除不可 | E-01（21-24行目） | ○ |
| C-08 | デフォルトテンプレートは削除不可 | E-01（26行目、条件判定） | ○ |
| C-09 | テンプレートIDの暗号化 | E-01（25-26行目、encrypt） | ○ |
| C-10 | ZIPサポート確認 | E-01（27-28行目） | ○ |
| C-11 | XStandardインストール案内 | E-01（29行目） | ○ |
| C-12 | オンラインテンプレート検索リンク | E-01（30行目） | ○ |
| C-13 | bBrowseOnlineTemplates設定による制御 | E-01（30行目） | ○ |
| C-14 | sNewTemplatesPath設定による制御 | E-01（31行目） | ○ |
| C-15 | installTemplate関数の実装 | E-01（83-125行目） | ○ |
| C-16 | templateCatList関数の実装 | E-01（40-59行目） | ○ |
| C-17 | showTemplateBox関数の実装 | E-01（60-82行目） | ○ |
| C-18 | テンプレート名表示 | E-01（26行目、sName） | ○ |
| C-19 | プレビューリンク | E-01（26行目、search） | ○ |
| C-20 | 機能名「テンプレート一覧」 | E-02（26行目） | ○ |
| C-21 | bs_templateList.aspが関連ファイル | E-02（26行目） | ○ |
| C-22 | 画面No.71が関連画面 | E-03（104-106行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する全ての主張がソースコードで確認済み
- 追加確認推奨: cls_templateクラスのcopy()、remove()メソッドの実装詳細

## 6) レビュアーチェックリスト（最小）
- [ ] bs_templateList.aspのソースコードが設計書の記載と一致することを確認
- [ ] テンプレート一覧のループ処理を確認
- [ ] copy/delete/defaultアクションの処理を確認
- [ ] 削除可否判定ロジックを確認
- [ ] ZIPサポート判定処理を確認
- [ ] installTemplate関数の動作を確認（推奨）
