---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-テンプレート作成・編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、重点レビュー項目なし
  2. cls_templateクラスの詳細実装確認（推奨）
  3. テンプレート変数一覧（bs_variables.asp）の確認（推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_templateEdit.asp` - テンプレート編集メイン（全36行）
- E-02: `asp/bs_CreateTemplate.asp` - ZIPからのテンプレート作成（全122行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bTemplates権限によるアクセス制御 | E-01（4行目） | ○ |
| C-02 | テキスト方向LTR固定 | E-01（4行目、QS_ltr） | ○ |
| C-03 | CSRFトークン検証（保存時） | E-01（8行目） | ○ |
| C-04 | CSRFトークン検証（削除時） | E-01（14行目） | ○ |
| C-05 | CSRFトークン検証（プレビュー時） | E-01（18行目） | ○ |
| C-06 | getRequestValues()による入力取得 | E-01（9行目、19行目） | ○ |
| C-07 | template.save()による保存 | E-01（10行目、20行目） | ○ |
| C-08 | template.remove()による削除 | E-01（15行目） | ○ |
| C-09 | 削除後テンプレート一覧へリダイレクト | E-01（16行目） | ○ |
| C-10 | プレビュー時セッションにID設定 | E-01（21行目） | ○ |
| C-11 | プレビューページへリダイレクト | E-01（22行目） | ○ |
| C-12 | 新規時にtemplate.init() | E-01（26行目） | ○ |
| C-13 | 削除可否判定 | E-01（29-32行目） | ○ |
| C-14 | テンプレート名入力フィールド | E-01（33行目、sName） | ○ |
| C-15 | HTMLテキストエリア（60行x110列） | E-01（33行目、rows="60" cols="110"） | ○ |
| C-16 | 圧縮版使用チェックボックス | E-01（34行目、bCompress） | ○ |
| C-17 | 機能名「テンプレート作成・編集」 | E-03（27行目） | ○ |
| C-18 | bs_templateEdit.asp、bs_CreateTemplate.aspが関連ファイル | E-03（27行目） | ○ |
| C-19 | 画面No.72、73が関連画面 | E-04（107-108行目） | ○ |
| C-20 | Artisteerテンプレート処理 | E-02（48-54行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する全ての主張がソースコードで確認済み
- 追加確認推奨: cls_templateクラスのgetRequestValues()、save()メソッドの実装詳細

## 6) レビュアーチェックリスト（最小）
- [ ] bs_templateEdit.aspのソースコードが設計書の記載と一致することを確認
- [ ] 保存/削除/プレビューのアクション処理を確認
- [ ] 削除可否判定ロジックを確認
- [ ] テキストエリアのサイズ設定を確認
- [ ] CSRFトークン検証が全アクションで実施されていることを確認
- [ ] bs_CreateTemplate.aspのZIPインポート処理を確認（推奨）
