---
generated_at: 2026-01-23 11:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-テンプレートプレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、重点レビュー項目なし
  2. default.aspのpreviewTemplateパラメータ処理確認（推奨）
  3. セッション変数のクリアタイミング確認（推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_templateList.asp` - プレビューリンク生成（26行目）
- E-02: `asp/bs_templateEdit.asp` - プレビューアクション処理（17-22行目、34-35行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレート一覧からwindow.openでプレビュー | E-01（26行目、getIcon内のJavaScript） | ○ |
| C-02 | プレビューURLにpreviewTemplateパラメータを含む | E-01（26行目） | ○ |
| C-03 | ホームページIDを指定してプレビュー | E-01（26行目、getHomePage.iId） | ○ |
| C-04 | テンプレートIDの暗号化 | E-01（26行目、encrypt） | ○ |
| C-05 | 編集画面プレビュー時のCSRFトークン検証 | E-02（18行目） | ○ |
| C-06 | getRequestValues()による入力値取得 | E-02（19行目） | ○ |
| C-07 | template.save()による一時保存 | E-02（20行目） | ○ |
| C-08 | session("iTemplateID")へのID設定 | E-02（21行目） | ○ |
| C-09 | default.aspへのリダイレクト | E-02（22行目） | ○ |
| C-10 | プレビューボタンのtarget='_new'設定 | E-02（34-35行目） | ○ |
| C-11 | 既存テンプレートの場合のみプレビューボタン表示 | E-02（34行目、isNumeriek判定） | ○ |
| C-12 | 機能名「テンプレートプレビュー」 | E-03（28行目） | ○ |
| C-13 | bs_templateList.asp内のプレビューリンクが関連ファイル | E-03（28行目） | ○ |
| C-14 | 画面No.22が関連画面 | E-04（35行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する全ての主張がソースコードで確認済み
- 追加確認推奨: default.aspでのpreviewTemplateパラメータ処理の実装詳細

## 6) レビュアーチェックリスト（最小）
- [ ] bs_templateList.aspのプレビューリンクが設計書の記載と一致することを確認
- [ ] bs_templateEdit.aspのプレビューアクション処理を確認
- [ ] window.openとtarget='_new'による新しいウィンドウ表示を確認
- [ ] session("iTemplateID")の設定処理を確認
- [ ] default.aspでのテンプレートID適用処理を確認（推奨）
