---
generated_at: 2026-01-23 11:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-テンプレートインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、重点レビュー項目なし
  2. cls_zipperクラスのunpack()メソッド確認（推奨）
  3. 許可ファイルタイプリストの確認（推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_uploadzip.asp` - ZIPアップロード画面（全38行）
- E-02: `asp/bs_unzip.asp` - ZIP解凍処理（全61行）
- E-03: `asp/bs_CreateTemplate.asp` - テンプレート作成（全122行）
- E-04: `asp/bs_templateList.asp` - 起点画面（27-29行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bTemplates権限によるアクセス制御 | E-01（4行目）、E-02（3行目） | ○ |
| C-02 | ZIPコンポーネントサポート確認 | E-01（4-6行目）、E-02（15行目） | ○ |
| C-03 | サポートなしの場合はリダイレクト | E-01（6行目） | ○ |
| C-04 | FreeASPUploadでファイル受信 | E-01（9-11行目） | ○ |
| C-05 | CSRFトークン検証（アップロード時） | E-01（17行目） | ○ |
| C-06 | ZIP形式のみ許可 | E-01（22-26行目） | ○ |
| C-07 | エラー時ファイル削除 | E-01（28行目） | ○ |
| C-08 | 成功時bs_unzip.aspへリダイレクト | E-01（30行目） | ○ |
| C-09 | デフォルト解凍先/templates | E-02（16-17行目） | ○ |
| C-10 | フォルダ名未指定時はZIPファイル名から生成 | E-02（26-27行目） | ○ |
| C-11 | zipper.unpack()で解凍 | E-02（34行目） | ○ |
| C-12 | オプションでZIPファイル削除 | E-02（36-39行目） | ○ |
| C-13 | 解凍成功時bs_CreateTemplate.aspへリダイレクト | E-02（48行目） | ○ |
| C-14 | cls_fileexplorerでフォルダ選択 | E-02（19行目、59行目） | ○ |
| C-15 | Artisteerテンプレート自動検出 | E-02（43行目、bTreatAsArt4）、E-03（21-25行目） | ○ |
| C-16 | JStemplateテンプレート自動検出 | E-02（43行目、treatASJSTemplate） | ○ |
| C-17 | 不許可ファイルタイプの削除 | E-03（96-99行目） | ○ |
| C-18 | XStandardインストール案内 | E-04（29行目） | ○ |
| C-19 | 機能名「テンプレートインポート」 | E-05（29行目） | ○ |
| C-20 | bs_uploadzip.asp、bs_unzip.aspが関連ファイル | E-05（29行目） | ○ |
| C-21 | 画面No.75、76が関連画面 | E-06（110-111行目） | ○ |
| C-22 | aspEasyZipコンポーネント使用 | E-01（37行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する全ての主張がソースコードで確認済み
- 追加確認推奨: cls_zipperクラスのunpack()メソッドの実装詳細、エラーハンドリング

## 6) レビュアーチェックリスト（最小）
- [ ] bs_uploadzip.aspのソースコードが設計書の記載と一致することを確認
- [ ] bs_unzip.aspの解凍処理を確認
- [ ] ZIP形式のみの拡張子チェックを確認
- [ ] CSRFトークン検証が実施されていることを確認
- [ ] cls_zipper.unpack()メソッドの動作を確認（推奨）
- [ ] 許可ファイルタイプリスト（allowedFileTypes）を確認（推奨）
