---
generated_at: 2026-01-23 11:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-オンラインテンプレート検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、重点レビュー項目なし
  2. 外部APIのエンドポイントURL確認（推奨）
  3. SaveBinaryData関数の実装確認（推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_templateSearch.asp` - オンラインテンプレート検索（全79行）
- E-02: `asp/bs_templateList.asp` - 起点画面（30行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bTemplates権限によるアクセス制御 | E-01（4行目） | ○ |
| C-02 | bBrowseOnlineTemplates設定による機能有効化 | E-02（30行目） | ○ |
| C-03 | ページング30件ずつ表示 | E-01（5行目、browseBy=30） | ○ |
| C-04 | MSXML2.ServerXMLHTTPによる外部通信 | E-01（11行目、41行目） | ○ |
| C-05 | セッションキャッシュの使用 | E-01（40-48行目） | ○ |
| C-06 | installパラメータによるインストール処理 | E-01（10行目） | ○ |
| C-07 | ファイルリスト取得 | E-01（13-15行目） | ○ |
| C-08 | フォルダ構造の自動作成 | E-01（20-26行目） | ○ |
| C-09 | on error resume nextでのエラー継続 | E-01（21行目、26行目） | ○ |
| C-10 | ファイルダウンロードループ | E-01（27-35行目） | ○ |
| C-11 | status=200の確認 | E-01（31行目） | ○ |
| C-12 | SaveBinaryDataによるファイル保存 | E-01（32行目） | ○ |
| C-13 | bs_CreateTemplate.aspへのリダイレクト | E-01（38行目） | ○ |
| C-14 | サムネイル画像表示 | E-01（59行目） | ○ |
| C-15 | bPopupFullWidthNoReloadクラスでポップアップ | E-01（59行目） | ○ |
| C-16 | インストール確認ダイアログ | E-01（60行目、confirm） | ○ |
| C-17 | navbalk関数によるページング | E-01（66-78行目） | ○ |
| C-18 | 機能名「オンラインテンプレート検索」 | E-03（30行目） | ○ |
| C-19 | bs_templateSearch.aspが関連ファイル | E-03（30行目） | ○ |
| C-20 | 画面No.74が関連画面 | E-04（109行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する全ての主張がソースコードで確認済み
- 追加確認推奨: 外部APIの可用性とセキュリティ

## 6) レビュアーチェックリスト（最小）
- [ ] bs_templateSearch.aspのソースコードが設計書の記載と一致することを確認
- [ ] MSXML2.ServerXMLHTTPによる外部通信処理を確認
- [ ] installパラメータ時のダウンロード・保存処理を確認
- [ ] ページング処理（navbalk関数）を確認
- [ ] セッションキャッシュの処理を確認
- [ ] SaveBinaryData関数の実装を確認（推奨）
