---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-セカンドアドミン管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先すべき項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_secondAdmin.asp` - セカンドアドミン管理画面（27行）
- E-02: `asp/includes/secondAdmin.asp` - cls_secondAdminクラス（233行）
- E-03: `asp/bs_security.asp` - セキュリティチェック（79行）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メイン管理者のみアクセス可能 | E-01（4行目: セカンドアドミンの場合リダイレクト） | ○ |
| C-02 | パスワード未設定時はbs_secondAdminPW.aspへリダイレクト | E-01（7行目） | ○ |
| C-03 | 40以上の権限フラグを持つ | E-02（2-8行目: Publicプロパティ定義） | ○ |
| C-04 | SHA-256でパスワードをハッシュ化 | E-02（174行目: sha256()） | ○ |
| C-05 | CSRF検証を実行 | E-01（15, 19行目: checkCSRF()） | ○ |
| C-06 | tblSecondAdminテーブルで権限を管理 | E-02（14行目: SELECT文、104行目: rs.Open） | ○ |
| C-07 | パスワードと確認用パスワードの一致チェック | E-02（80-82行目） | ○ |
| C-08 | メイン管理者パスワードとの重複チェック | E-02（83-85行目） | ○ |
| C-09 | デフォルトパスワード禁止 | E-02（86-89行目: sha256(QS_defaultPW)） | ○ |
| C-10 | save処理でメニューキャッシュをクリア | E-02（169行目: clearMenuCache） | ○ |
| C-11 | delete処理でDELETE文を実行 | E-02（228-230行目） | ○ |
| C-12 | ページ追加権限はbPagesAdd | E-02（5行目） | ○ |
| C-13 | ページ削除権限はbPagesDelete | E-02（5行目） | ○ |
| C-14 | 一般設定権限はbSetupGeneral | E-02（3行目） | ○ |
| C-15 | テンプレート管理権限はbTemplates | E-02（3行目） | ○ |
| C-16 | フォーム管理権限はbForms | E-02（4行目） | ○ |
| C-17 | 新規レコードの場合はAddNew | E-02（106行目） | ○ |
| C-18 | 既存レコードの場合はUpdate | E-02（166行目） | ○ |
| C-19 | 関連画面No.113,115,116 | E-05 | ○ |
| C-20 | 主要ファイルはbs_secondAdmin.asp | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての権限フラグがソースコードで確認済み
- 0: 低リスク - パスワード検証ロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] 全ての権限フラグがbs_security.aspで正しく適用されているか確認
- [ ] 権限の階層構造（親権限と子権限の関係）が正しく動作するか確認
- [ ] 削除後のリダイレクト先が適切か確認
