---
generated_at: 2026-01-23 11:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-デフォルトテンプレート設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、重点レビュー項目なし
  2. フロントエンドでのdefaultTemplate参照処理確認（推奨）
  3. 個別ページテンプレート設定との優先順位確認（推奨）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_templateList.asp` - デフォルト設定処理（6-17行目、26行目）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | secondAdmin.bTemplates権限によるアクセス制御 | E-01（4行目） | ○ |
| C-02 | CSRFトークン検証 | E-01（7行目） | ○ |
| C-03 | a="default"でアクション判定 | E-01（8行目、13行目） | ○ |
| C-04 | customer.defaultTemplate設定 | E-01（14行目） | ○ |
| C-05 | customer.save()による保存 | E-01（15行目） | ○ |
| C-06 | テンプレートIDの暗号化/復号 | E-01（6行目、encrypt/decrypt） | ○ |
| C-07 | ID有効性チェック（convertGetal<>0） | E-01（6行目） | ○ |
| C-08 | 現在のデフォルトに(default)表示 | E-01（26行目） | ○ |
| C-09 | デフォルト以外に(set as default)リンク表示 | E-01（26行目） | ○ |
| C-10 | デフォルトテンプレートの削除不可（削除リンク非表示） | E-01（26行目） | ○ |
| C-11 | QS_secCodeURLによるCSRFトークン付与 | E-01（26行目） | ○ |
| C-12 | 機能名「デフォルトテンプレート設定」 | E-02（31行目） | ○ |
| C-13 | bs_templateList.asp内のsetaasdefaultアクションが関連 | E-02（31行目） | ○ |
| C-14 | 画面No.71が関連画面 | E-03（106行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作に関する全ての主張がソースコードで確認済み
- 追加確認推奨: フロントエンドでのdefaultTemplate参照・適用処理

## 6) レビュアーチェックリスト（最小）
- [ ] bs_templateList.aspのdefaultアクション処理を確認
- [ ] CSRFトークン検証が実施されていることを確認
- [ ] customer.defaultTemplate設定と保存処理を確認
- [ ] デフォルト判定による表示分岐を確認
- [ ] デフォルトテンプレートの削除リンク非表示を確認
- [ ] フロントエンドでのdefaultTemplate参照処理を確認（推奨）
