---
generated_at: 2026-01-23 21:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-モバイル設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **テンプレート優先ルール**：排他的使用のロジックがコード内で明示されていない
  2. **レスポンス時間要件**：パフォーマンス要件の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `asp/bs_mobileSetup.asp` - モバイル設定画面メイン処理
- E-02: `asp/includes/customer.asp` - cls_customerクラス定義（16行目、190-192行目、437-439行目）
- E-03: `asp/bs_security.asp` - セキュリティ・認証処理
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.85のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モバイル設定機能はbs_mobileSetup.aspで実装されている | E-01 | ○ |
| C-02 | sMOBBrowsers, sMOBUrl, iDefaultMobileTemplateがcustomerオブジェクトのプロパティ | E-02 | ○ |
| C-03 | postback=1でフォーム値が取得される | E-01 (7-12行目) | ○ |
| C-04 | sMOBUrlが空の場合は"http://"が初期設定される | E-01 (4-6行目) | ○ |
| C-05 | checkMobileBrowserセッションがクリアされる | E-01 (8行目) | ○ |
| C-06 | iDefaultMobileTemplateは暗号化されて送受信される | E-01 (11行目) | ○ |
| C-07 | customer.save()で設定が保存される | E-01 (14-15行目) | ○ |
| C-08 | 保存後にfbMessage=fb_saveOKでリダイレクトされる | E-01 (15行目) | ○ |
| C-09 | bs_security.aspで認証チェックが行われる | E-01 (4行目インクルード) | ○ |
| C-10 | tblCustomerテーブルに設定が保存される | E-02 (437-439行目) | ○ |
| C-11 | HTTP_USER_AGENTの最新履歴が表示される | E-01 (16行目) | ○ |
| C-12 | 画面No.85がモバイル設定に対応 | E-04 | ○ |
| C-13 | sanitize関数でXSS対策されている | E-01 (16行目) | ○ |
| C-14 | セカンドアドミンのアクセス権限が存在する | E-02 (secondAdminプロパティ) | ○ |
| C-15 | テンプレート選択ドロップダウンが表示される | E-01 (16行目) | ○ |
| C-16 | トランザクション管理はcustomer.save()内で行われる | E-02 (Save関数) | ○ |
| C-17 | テンプレートとURLは排他的に使用される | **根拠なし** | △ |
| C-18 | レスポンス時間1秒以内の要件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- テンプレートとURLの排他制御に関するロジックがコード内で明示的に確認できない
  - 候補：フロントエンド表示処理 / process.asp / default.asp
- パフォーマンス要件の根拠となる設計書やSLAドキュメントが不明
  - 候補：非機能要件定義書 / 運用マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD操作であり、複雑なビジネスロジックは含まれない
- 1: 中リスク - モバイル判別ロジックの正確性確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] sMOBBrowsersに設定するキーワードの推奨値が文書化されているか確認
- [ ] テンプレートとURLの同時設定時の動作を実機で確認
- [ ] セカンドアドミンの権限設定が適切に反映されるか確認
