---
generated_at: 2026-01-23 21:42:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-ポップアップ効果設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_popupMode.asp` - ポップアップモード設定画面メイン処理
- E-02: `asp/includes/customer.asp` - cls_customerクラス定義（9行目、168行目、416行目、1517-1523行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.67のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ポップアップ効果設定はbs_popupMode.aspで実装されている | E-01 | ○ |
| C-02 | sPopupViewmodeはcustomerオブジェクトのプロパティ | E-02 (9行目) | ○ |
| C-03 | 5種類のスタイル選択が可能（1-5） | E-01 (ラジオボタン定義) | ○ |
| C-04 | sPopupViewmodeが空でない場合に保存処理が実行される | E-01 (4行目) | ○ |
| C-05 | customer.save()で設定が保存される | E-01 (6行目) | ○ |
| C-06 | 保存後にfbMessage=fb_saveOKでリダイレクトされる | E-01 (7行目) | ○ |
| C-07 | Dark Rounded SquareはsPopupViewmode=1に対応 | E-01 | ○ |
| C-08 | Light Squareはsポップアップビューモード=2に対応 | E-01 | ○ |
| C-09 | tblCustomerテーブルに設定が保存される | E-02 (416行目) | ○ |
| C-10 | sGetPopupModeプロパティでデフォルト値"1"が返される | E-02 (1517-1523行目) | ○ |
| C-11 | 画面No.67がポップアップモード設定に対応 | E-03 | ○ |
| C-12 | bs_security.aspで認証チェックが行われる | E-01 (インクルード) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（機能がシンプルなため、必要な情報はすべて確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単純な設定値の保存機能であり、複雑なロジックなし

## 6) レビュアーチェックリスト（最小）
- [ ] 5種類すべてのスタイルが実際に異なるビジュアルで表示されることを確認
- [ ] フロントエンドでのポップアップ表示時にスタイルが正しく適用されることを確認
