---
generated_at: 2026-01-23 21:44:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-アコーディオンCSS設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_AccordionSetup.asp` - アコーディオンCSS設定画面メイン処理
- E-02: `asp/includes/customer.asp` - cls_customerクラス定義（18行目、206-208行目、223-225行目、450-452行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.189のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アコーディオンCSS設定はbs_AccordionSetup.aspで実装されている | E-01 | ○ |
| C-02 | sQSAccordionMain, sQSAccordionHeader, sQSAccordionContentが設定項目 | E-02 (18行目) | ○ |
| C-03 | loaddark=1でダークCSS設定が読み込まれる | E-01 (12-18行目) | ○ |
| C-04 | loaddefault=1でデフォルト（空）CSS設定が読み込まれる | E-01 (19-25行目) | ○ |
| C-05 | suggestcssでトライアド配色計算が実行される | E-01 (26-48行目) | ○ |
| C-06 | HEXCOL2RGB関数で色変換が行われる | E-01 (29行目) | ○ |
| C-07 | triad = 16777216 / 3で色相環の1/3を計算 | E-01 (30行目) | ○ |
| C-08 | ダークプリセットは#222222背景に#FFFFFF文字 | E-01 (13-15行目) | ○ |
| C-09 | デフォルトヘッダーCSSは#DDDDDD背景 | E-02 (224行目) | ○ |
| C-10 | デフォルトコンテンツCSSは#FFFFFF背景 | E-02 (225行目) | ○ |
| C-11 | customer.save()で設定が保存される | E-01 (16, 23, 46, 53行目) | ○ |
| C-12 | tblCustomerテーブルに設定が保存される | E-02 (450-452行目) | ○ |
| C-13 | jQueryアコーディオンプラグインが使用される | E-01 (55行目) | ○ |
| C-14 | リアルタイムプレビューが表示される | E-01 (55行目) | ○ |
| C-15 | JQColorPickerでカラーピッカーが提供される | E-01 (55行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（機能の主要な処理はすべてbs_AccordionSetup.aspで完結）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CSS設定機能であり、セキュリティリスクは管理者限定で低い

## 6) レビュアーチェックリスト（最小）
- [ ] トライアド配色計算が正しく動作することを確認
- [ ] 生成されたCSSがフロントエンドで正しく適用されることを確認
- [ ] ダーク/デフォルトプリセットの切り替えが正常に動作することを確認
