---
generated_at: 2026-01-23 21:46:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-Cookie警告設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_cookiewarning.asp` - Cookie警告設定画面メイン処理
- E-02: `asp/includes/customer.asp` - cls_customerクラス定義（17行目、194-205行目、440-449行目、1562-1610行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.84のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Cookie警告設定はbs_cookiewarning.aspで実装されている | E-01 | ○ |
| C-02 | セカンドアドミンのbCookieWarning権限チェックが行われる | E-01 (4行目) | ○ |
| C-03 | language=2はオランダ語として判定される | E-01 (8行目, 39行目) | ○ |
| C-04 | デフォルト設定ではsCWLocation="top"が設定される | E-01 (9行目, 21行目) | ○ |
| C-05 | デフォルト背景色は#000000 | E-01 (15行目, 27行目) | ○ |
| C-06 | デフォルトテキスト色は#FFFFFF | E-01 (17行目, 29行目) | ○ |
| C-07 | ミニマル設定ではsCWTextが空になる | E-01 (42行目, 54行目) | ○ |
| C-08 | customer.save()で設定が保存される | E-01 (33行目, 64行目, 81行目) | ○ |
| C-09 | 保存後にfbMessage=fb_saveOKでリダイレクトされる | E-01 (34行目, 65行目, 82行目) | ○ |
| C-10 | sCWNumberは0-20の範囲で設定可能 | E-01 (87行目) | ○ |
| C-11 | JQColorPickerでカラーピッカーが提供される | E-01 (87行目) | ○ |
| C-12 | dumpFCKInstanceでWYSIWYGエディタが提供される | E-01 (87行目) | ○ |
| C-13 | tblCustomerテーブルに設定が保存される | E-02 (440-449行目) | ○ |
| C-14 | sCookieJS関数でフロントエンド用JSが生成される | E-02 (1562-1610行目) | ○ |
| C-15 | CookieDirective15.jsがフロントエンドで使用される | E-02 (1575行目) | ○ |
| C-16 | bCWUseAsNormalPPで同意ブロックを非表示にできる | E-01 (86行目), E-02 (1603-1605行目) | ○ |
| C-17 | QSbcwp=1でプレビューモードが有効になる | E-01 (86行目), E-02 (227-229行目) | ○ |
| C-18 | 画面No.84がCookie警告設定に対応 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - GDPR対応の設定機能であり、法的要件を満たす設定が可能

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルト/ミニマル設定が言語に応じて正しく適用されることを確認
- [ ] フロントエンドでCookie警告が正しく表示されることを確認
- [ ] 表示回数制限が正しく動作することを確認
- [ ] 同意チェックボックスの表示/非表示が切り替わることを確認
