---
generated_at: 2026-01-23 21:48:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-カスタム404ページ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `asp/bs_404.asp` - カスタム404ページ設定画面メイン処理
- E-02: `asp/includes/customer.asp` - cls_customerクラス定義（18行目、53-56行目、215-221行目、460-464行目）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.200のマッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カスタム404ページ設定はbs_404.aspで実装されている | E-01 | ○ |
| C-02 | セカンドアドミンのbCustom404権限チェックが行われる | E-01 (2行目) | ○ |
| C-03 | bCustom404, sCustom404Title, sCustom404Body, i404TemplateIDが設定項目 | E-02 (18行目) | ○ |
| C-04 | デフォルトタイトルは"File Not Found" | E-02 (54行目), E-01 (20行目) | ○ |
| C-05 | デフォルト本文には[404FILENAME]プレースホルダーが含まれる | E-02 (55行目), E-01 (21行目) | ○ |
| C-06 | sCustom404Titleは最大250文字 | E-01 (10行目: left関数) | ○ |
| C-07 | i404TemplateIDは暗号化されて送受信される | E-01 (12行目: decrypt関数) | ○ |
| C-08 | customer.save()で設定が保存される | E-01 (14行目) | ○ |
| C-09 | 保存後にfbMessage=fb_saveOKでリダイレクトされる | E-01 (15行目) | ○ |
| C-10 | dumpFCKInstanceでWYSIWYGエディタが提供される | E-01 (36行目) | ○ |
| C-11 | showSelectedtemplateでテンプレート選択ドロップダウンが生成される | E-01 (37行目) | ○ |
| C-12 | tblCustomerテーブルに設定が保存される | E-02 (460-464行目) | ○ |
| C-13 | Class_Initializeでデフォルト値が設定される | E-02 (53-56行目) | ○ |
| C-14 | 画面No.200が404エラー設定に対応 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単純な設定機能

## 6) レビュアーチェックリスト（最小）
- [ ] [404FILENAME]プレースホルダーが正しく置換されることを確認
- [ ] 選択したテンプレートが404ページに適用されることを確認
- [ ] bCustom404=falseの場合にデフォルト404ページが表示されることを確認
